/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common;

import com.direwolf20.mininggadgets.client.ClientEvents;
import com.direwolf20.mininggadgets.client.ClientSetup;
import com.direwolf20.mininggadgets.client.OurKeys;
import com.direwolf20.mininggadgets.common.Config;
import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.containers.ModContainers;
import com.direwolf20.mininggadgets.common.events.ServerTickHandler;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.ModItems;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.EndRodBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.RedstoneLampBlock;
import net.minecraft.block.RedstoneOreBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mininggadgets")
public class MiningGadgets {
    public static final String MOD_ID = "mininggadgets";
    private static final Logger LOGGER = LogManager.getLogger();
    public static ItemGroup itemGroup = new ItemGroup("mininggadgets"){

        public ItemStack func_78016_d() {
            ItemStack itemStack = new ItemStack((IItemProvider)ModItems.MININGGADGET.get());
            itemStack.func_196082_o().func_74768_a("energy", Integer.MAX_VALUE);
            return itemStack;
        }
    };

    public MiningGadgets() {
        IEventBus event = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(event);
        ModItems.UPGRADE_ITEMS.register(event);
        ModBlocks.BLOCKS.register(event);
        ModBlocks.TILES_ENTITIES.register(event);
        ModContainers.CONTAINERS.register(event);
        event.addListener(this::setup);
        event.addListener(this::setupClient);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        event.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.loadConfig(Config.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("mininggadgets-client.toml"));
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("mininggadgets-common.toml"));
    }

    @SubscribeEvent
    public void rightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = MiningGadget.getGadget(event.getPlayer());
        if (stack.func_77973_b() instanceof MiningGadget && (this.stackIsAnnoying(event.getPlayer().func_184614_ca()) || this.stackIsAnnoying(event.getPlayer().func_184592_cb()) || event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof RedstoneOreBlock)) {
            event.setCanceled(true);
        }
    }

    private boolean stackIsAnnoying(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof BlockItem)) {
            return false;
        }
        Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
        return block instanceof TorchBlock || block instanceof LanternBlock || block.equals(Blocks.field_150426_aN) || block instanceof RedstoneLampBlock || block instanceof EndRodBlock;
    }

    private void setup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        MinecraftForge.EVENT_BUS.register(ServerTickHandler.class);
    }

    private void setupClient(FMLClientSetupEvent event) {
        ClientSetup.setup();
        OurKeys.register();
        MinecraftForge.EVENT_BUS.register(ClientEvents.class);
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

