/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.tiles.ModificationTableTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class ModificationShiftOverlay {
    public static void render(RenderWorldLastEvent evt, PlayerEntity player) {
        RayTraceResult pick = player.func_213324_a(5.0, 0.0f, false);
        if (pick.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult trace = (BlockRayTraceResult)pick;
        if (player.field_70170_p.func_180495_p(trace.func_216350_a()).func_177230_c() != ModBlocks.MODIFICATION_TABLE.get()) {
            return;
        }
        TileEntity blockEntity = player.field_70170_p.func_175625_s(trace.func_216350_a());
        if (!(blockEntity instanceof ModificationTableTileEntity)) {
            return;
        }
        ItemStack stack = ((ModificationTableTileEntity)blockEntity).handler.map(e -> e.getStackInSlot(0)).orElse(ItemStack.field_190927_a);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof MiningGadget)) {
            return;
        }
        List<Upgrade> upgrades = UpgradeTools.getUpgrades(stack);
        if (upgrades.isEmpty()) {
            return;
        }
        Vector3d view = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        BlockPos blockPos = ((BlockRayTraceResult)pick).func_216350_a();
        double distance = player.func_242282_l(evt.getPartialTicks()).func_72438_d(new Vector3d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()));
        float scaleFactor = Math.max(0.2f, (float)distance / 10.0f + 0.1f);
        MatrixStack matrix = evt.getMatrixStack();
        matrix.func_227860_a_();
        matrix.func_227861_a_(-view.field_72450_a, -view.field_72448_b, -view.field_72449_c);
        matrix.func_227861_a_((double)((float)blockPos.func_177958_n() + 0.5f), (double)(blockPos.func_177956_o() + 1), (double)((float)blockPos.func_177952_p() + 0.5f));
        matrix.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        matrix.func_227863_a_(Minecraft.func_71410_x().func_175598_ae().func_229098_b_());
        IRenderTypeBuffer.Impl outlineLayerBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        int x = 0;
        int y = 0;
        float offset = upgrades.size() / 3 > 0 ? -1.15f : (upgrades.size() > 1 ? -((float)upgrades.size() / 3.0f) : -0.2f);
        for (Upgrade upgrade : upgrades) {
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)(offset + (float)x), (double)y, 0.0);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(26.0f));
            ItemStack upgradeStack = upgrade.getStack();
            IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(upgradeStack, (World)Minecraft.func_71410_x().field_71441_e, null);
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(upgradeStack, ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, false, matrix, (IRenderTypeBuffer)outlineLayerBuffer, 0xF000F0, OverlayTexture.field_229196_a_, model);
            if (++x > 2) {
                x = 0;
                ++y;
            }
            matrix.func_227865_b_();
        }
        outlineLayerBuffer.func_228461_a_();
        matrix.func_227865_b_();
    }
}

