/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import snownee.lightingwand.common.ModConstants;

public class RepairRecipe
implements ICraftingRecipe {
    private final ResourceLocation Id;
    private final String group;
    private final Item repairable;
    private final Ingredient material;
    private final int ratio;

    public RepairRecipe(ResourceLocation Id, String group, Item repairable, Ingredient material, int ratio) {
        this.Id = Id;
        this.group = group;
        this.repairable = repairable;
        this.material = material;
        this.ratio = ratio;
        if (repairable.func_77612_l() == 0) {
            throw new IllegalArgumentException(String.format("Recipe: %s, Item %s is not repairable", Id, repairable.getRegistryName()));
        }
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_194133_a(int width, int height) {
        return width > 1 || height > 1;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        int dust = 0;
        ItemStack wand = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_77973_b() == this.repairable && itemstack.func_77952_i() != 0) {
                if (wand.func_190926_b()) {
                    wand = itemstack;
                    continue;
                }
                return false;
            }
            if (!itemstack.func_190926_b() && this.material.test(itemstack)) {
                ++dust;
                continue;
            }
            if (itemstack == ItemStack.field_190927_a) continue;
            return false;
        }
        return !wand.func_190926_b() && dust > 0 && wand.func_77952_i() - MathHelper.func_76123_f((float)(wand.func_77958_k() / this.ratio)) * dust > -MathHelper.func_76123_f((float)(wand.func_77958_k() / this.ratio));
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        int dust = 0;
        ItemStack wand = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            int count;
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_77973_b() == this.repairable) {
                wand = itemstack;
                continue;
            }
            if (itemstack.func_190926_b() || !this.material.test(itemstack) || (count = itemstack.func_190916_E()) <= 0) continue;
            ++dust;
        }
        int damage = MathHelper.func_76125_a((int)(wand.func_77952_i() - MathHelper.func_76123_f((float)(wand.func_77958_k() / this.ratio)) * dust), (int)0, (int)ModConstants.WAND.getMaxDamage(wand));
        ItemStack result = new ItemStack((IItemProvider)this.repairable, 1, wand.func_77978_p());
        result.func_196085_b(damage);
        return result;
    }

    public ResourceLocation func_199560_c() {
        return this.Id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModConstants.REPAIR;
    }

    public String func_193358_e() {
        return this.group;
    }

    public Ingredient getMaterial() {
        return this.material;
    }

    public Item getRepairable() {
        return this.repairable;
    }

    public int getRatio() {
        return this.ratio;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RepairRecipe> {
        public RepairRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            String s = JSONUtils.func_151200_h((JsonObject)json, (String)"repairable");
            Item repairable = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
            if (repairable == null) {
                throw new JsonSyntaxException("Unknown item '" + s + "'");
            }
            Ingredient material = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"material"));
            int ratio = JSONUtils.func_151203_m((JsonObject)json, (String)"ratio");
            return new RepairRecipe(recipeId, group, repairable, material, ratio);
        }

        public RepairRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            Item repairable = Item.func_150899_d((int)buffer.func_150792_a());
            Ingredient material = Ingredient.func_199566_b((PacketBuffer)buffer);
            int ratio = buffer.func_150792_a();
            return new RepairRecipe(recipeId, group, repairable, material, ratio);
        }

        public void write(PacketBuffer buffer, RepairRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            buffer.func_150787_b(Item.func_150891_b((Item)recipe.repairable));
            recipe.material.func_199564_a(buffer);
            buffer.func_150787_b(recipe.ratio);
        }
    }
}

