/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.TileEntityBaseContainerScreen;
import com.supermartijn642.trashcans.TrashCanTile;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class TrashCanScreen<T extends TrashCanContainer>
extends TileEntityBaseContainerScreen<TrashCanTile, T> {
    public TrashCanScreen(T container, String title) {
        super(container, (ITextComponent)new TranslationTextComponent(title));
        this.setDrawSlots(false);
    }

    protected int sizeX(TrashCanTile trashCanTile) {
        return ((TrashCanContainer)this.field_147002_h).width;
    }

    protected int sizeY(TrashCanTile trashCanTile) {
        return ((TrashCanContainer)this.field_147002_h).height;
    }

    protected abstract String getBackground();

    protected void renderBackground(MatrixStack matrixStack, int mouseX, int mouseY, TrashCanTile tile) {
        ScreenUtils.bindTexture((ResourceLocation)new ResourceLocation("trashcans", "textures/" + this.getBackground()));
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)0.0f, (float)0.0f, (float)this.sizeX(), (float)this.sizeY());
    }

    protected void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY, TrashCanTile tile) {
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (ITextComponent)this.field_230704_d_, (float)((float)this.sizeX() / 2.0f), (float)6.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)this.field_213127_e.func_145748_c_(), (float)21.0f, (float)(this.sizeY() - 94));
        this.drawText(matrixStack, tile);
    }

    protected abstract void drawText(MatrixStack var1, TrashCanTile var2);

    public void renderToolTip(MatrixStack matrixStack, boolean translate, String string, int x, int y) {
        super.func_238652_a_(matrixStack, (ITextComponent)(translate ? new TranslationTextComponent(string) : new StringTextComponent(string)), x, y);
    }

    public void renderToolTip(MatrixStack matrixStack, List<ITextComponent> text, int x, int y) {
        super.renderWrappedToolTip(matrixStack, text, x, y, this.field_230712_o_);
    }
}

