/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.packet;

import com.supermartijn642.trashcans.TrashCanTile;
import com.supermartijn642.trashcans.packet.TrashCanPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketChangeEnergyLimit
extends TrashCanPacket {
    private int amount;

    public PacketChangeEnergyLimit(BlockPos pos, int amount) {
        super(pos);
        this.amount = amount;
    }

    public PacketChangeEnergyLimit(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        super.encode(buffer);
        buffer.writeInt(this.amount);
    }

    @Override
    protected void decodeBuffer(PacketBuffer buffer) {
        super.decodeBuffer(buffer);
        this.amount = buffer.readInt();
    }

    public static PacketChangeEnergyLimit decode(PacketBuffer buffer) {
        return new PacketChangeEnergyLimit(buffer);
    }

    @Override
    protected void handle(PlayerEntity player, World world, TrashCanTile tile) {
        int amount;
        int limit;
        if (tile.energy && Math.abs(this.amount) >= 1 && Math.abs(this.amount) <= 10000 && tile.energyLimit != (limit = Math.min(Math.max(amount = tile.energyLimit == 1 && this.amount > 1 ? this.amount : tile.energyLimit + this.amount, 1), 10000000))) {
            tile.energyLimit = limit;
            tile.dataChanged();
        }
    }
}

