/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.util;

import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledCard;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import net.minecraft.nbt.CompoundNBT;

public class CardInfo {
    private int itemAllocation;
    private int varAllocation;
    private int fluidAllocation;
    private CompiledCard compiledCard;
    private int[] slotCache = null;
    private int[] varCache = null;
    private int[] fluidCache = null;

    public int getFluidAllocation() {
        return this.fluidAllocation;
    }

    public void setFluidAllocation(int fluidAllocation) {
        this.fluidAllocation = fluidAllocation;
        this.fluidCache = null;
    }

    public int getItemAllocation() {
        return this.itemAllocation;
    }

    public void setItemAllocation(int itemAllocation) {
        this.itemAllocation = itemAllocation;
        this.slotCache = null;
    }

    public int getVarAllocation() {
        return this.varAllocation;
    }

    public void setVarAllocation(int varAllocation) {
        this.varAllocation = varAllocation;
        this.varCache = null;
    }

    public void setCompiledCard(CompiledCard compiledCard) {
        this.compiledCard = compiledCard;
    }

    public CompiledCard getCompiledCard() {
        return this.compiledCard;
    }

    public Integer getRealFluidSlot(Integer virtualSlot) {
        if (virtualSlot == null) {
            return null;
        }
        return this.getRealFluidSlot((int)virtualSlot);
    }

    public int getRealFluidSlot(int virtualSlot) {
        int realSlot;
        if (this.fluidCache == null) {
            this.fluidCache = new int[24];
            int idx = 0;
            for (int i = 0; i < 24; ++i) {
                if ((this.fluidAllocation >> i & 1) != 1) continue;
                this.fluidCache[idx] = i;
                ++idx;
            }
            while (idx < 24) {
                this.fluidCache[idx] = -1;
                ++idx;
            }
        }
        if ((realSlot = this.fluidCache[virtualSlot]) == -1) {
            throw new ProgException(ExceptionType.EXCEPT_NOINTERNALFLUIDSLOT);
        }
        return realSlot;
    }

    public Integer getRealSlot(Integer virtualSlot) {
        if (virtualSlot == null) {
            return null;
        }
        return this.getRealSlot((int)virtualSlot);
    }

    public int getRealSlot(int virtualSlot) {
        int realSlot;
        if (this.slotCache == null) {
            this.slotCache = new int[24];
            int idx = 0;
            for (int i = 0; i < 24; ++i) {
                if ((this.itemAllocation >> i & 1) != 1) continue;
                this.slotCache[idx] = i;
                ++idx;
            }
            while (idx < 24) {
                this.slotCache[idx] = -1;
                ++idx;
            }
        }
        if ((realSlot = this.slotCache[virtualSlot]) == -1) {
            throw new ProgException(ExceptionType.EXCEPT_NOINTERNALSLOT);
        }
        return realSlot + 22;
    }

    public int getRealVar(int virtualVar) {
        if (this.varCache == null) {
            this.varCache = new int[32];
            int idx = 0;
            for (int i = 0; i < 32; ++i) {
                if ((this.varAllocation >> i & 1) != 1) continue;
                this.varCache[idx] = i;
                ++idx;
            }
            while (idx < 32) {
                this.varCache[idx] = -1;
                ++idx;
            }
        }
        return this.varCache[virtualVar];
    }

    public Integer getRealVar(Integer virtualVar) {
        if (virtualVar == null) {
            return null;
        }
        return this.getRealVar((int)virtualVar);
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("itemAlloc", this.itemAllocation);
        tag.func_74768_a("varAlloc", this.varAllocation);
        tag.func_74768_a("fluidAlloc", this.fluidAllocation);
        return tag;
    }

    public static CardInfo readFromNBT(CompoundNBT tag) {
        CardInfo cardInfo = new CardInfo();
        cardInfo.itemAllocation = tag.func_74762_e("itemAlloc");
        cardInfo.varAllocation = tag.func_74762_e("varAlloc");
        cardInfo.fluidAllocation = tag.func_74762_e("fluidAlloc");
        cardInfo.slotCache = null;
        cardInfo.varCache = null;
        cardInfo.fluidCache = null;
        return cardInfo;
    }
}

