/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.network.PacketVariablesReady;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGetVariables {
    private BlockPos pos;
    private RegistryKey<World> type;
    private TypedMap params;
    private boolean fromTablet;

    public PacketGetVariables(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.type = LevelTools.getId((ResourceLocation)buf.func_192575_l());
        this.params = TypedMapTools.readArguments((PacketBuffer)buf);
        this.fromTablet = buf.readBoolean();
    }

    public PacketGetVariables(BlockPos pos, RegistryKey<World> type, boolean fromTablet) {
        this.pos = pos;
        this.type = type;
        this.params = TypedMap.EMPTY;
        this.fromTablet = fromTablet;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_192572_a(this.type.func_240901_a_());
        TypedMapTools.writeArguments((PacketBuffer)buf, (TypedMap)this.params);
        buf.writeBoolean(this.fromTablet);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te;
            ServerWorld world = LevelTools.getLevel((World)ctx.getSender().func_130014_f_(), this.type);
            if (world.func_175667_e(this.pos) && (te = world.func_175625_s(this.pos)) instanceof GenericTileEntity) {
                List list = ((GenericTileEntity)te).executeServerCommandList(ProcessorTileEntity.CMD_GETVARS.getName(), (PlayerEntity)ctx.getSender(), this.params, Parameter.class);
                RFToolsCtrlMessages.INSTANCE.sendTo((Object)new PacketVariablesReady(this.fromTablet ? null : this.pos, ProcessorTileEntity.CMD_GETVARS.getName(), list), ctx.getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
        ctx.setPacketHandled(true);
    }
}

