/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.craftingstation.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolscontrol.modules.craftingstation.CraftingStationModule;
import mcjty.rftoolscontrol.modules.craftingstation.client.GuiCraftingStation;
import mcjty.rftoolscontrol.modules.craftingstation.util.CraftingRequest;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingStationTileEntity
extends GenericTileEntity {
    public static final int SLOT_OUTPUT = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(9).box(SlotDefinition.generic(), 0, 6, 157, 3, 3).playerSlots(66, 157));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.basic((GenericTileEntity)this, CONTAINER_FACTORY);
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Crafter").containerSupplier(DefaultContainerProvider.container(CraftingStationModule.CRAFTING_STATION_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    private final List<BlockPos> processorList = new ArrayList<BlockPos>();
    private int currentTicket = 0;
    private List<CraftingRequest> activeCraftingRequests = new ArrayList<CraftingRequest>();
    private int cleanupCounter = 50;
    public static final Key<String> PARAM_ITEMNAME = new Key("itemname", Type.STRING);
    public static final Key<String> PARAM_NBT = new Key("nbt", Type.STRING);
    public static final Key<Integer> PARAM_AMOUNT = new Key("amount", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_REQUEST = Command.create((String)"station.request", (te, player, params) -> {
        String nbtString;
        String itemName = (String)params.get(PARAM_ITEMNAME);
        int index = te.findItem(itemName, nbtString = (String)params.get(PARAM_NBT));
        if (index == -1) {
            return;
        }
        te.startCraft(index, (Integer)params.get(PARAM_AMOUNT));
    });
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_CANCEL = Command.create((String)"station.cancel", (te, player, params) -> te.cancelCraft((Integer)params.get(PARAM_INDEX)));
    @ServerCommand(type=ItemStack.class)
    public static final ListCommand<?, ?> CMD_GETCRAFTABLE = ListCommand.create((String)"rftoolscontrol.station.getCraftable", (te, player, params) -> te.getCraftableItems(), (te, player, params, list) -> GuiCraftingStation.storeCraftableForClient(list));
    @ServerCommand(type=CraftingRequest.class, serializer=CraftingRequest.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETREQUESTS = ListCommand.create((String)"rftoolscontrol.station.getRequests", (te, player, params) -> te.getRequests(), (te, player, params, list) -> GuiCraftingStation.storeRequestsForClient(list));

    public CraftingStationTileEntity() {
        super((TileEntityType)CraftingStationModule.CRAFTING_STATION_TILE.get());
    }

    public void registerProcessor(BlockPos pos) {
        if (!this.processorList.contains(pos)) {
            this.processorList.add(pos);
        }
        this.func_70296_d();
    }

    public ItemStack getCraftResult(String craftId) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!craftId.equals(request.getTicket())) continue;
            return request.getStack();
        }
        return ItemStack.field_190927_a;
    }

    private Pair<ProcessorTileEntity, ItemStack> findCraftableItem(int index) {
        for (BlockPos p : this.processorList) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack item : items) {
                if (index == 0) {
                    return Pair.of((Object)((Object)processor), (Object)item);
                }
                --index;
            }
        }
        return null;
    }

    public ItemStack craftOk(ProcessorTileEntity processor, String ticket, ItemStack stack) {
        CraftingRequest foundRequest = null;
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!ticket.equals(request.getTicket())) continue;
            foundRequest = request;
            break;
        }
        if (foundRequest != null) {
            this.func_70296_d();
            foundRequest.decrTodo();
            if (foundRequest.getTodo() <= 0) {
                foundRequest.setOk(System.currentTimeMillis() + 1000L);
            } else {
                processor.fireCraftEvent(ticket, foundRequest.getStack());
            }
            if (!stack.func_190926_b()) {
                Inventory inventory = this.getInventoryFromTicket(ticket);
                if (inventory != null) {
                    return (ItemStack)processor.getItemHandlerAt(inventory).map(handlerAt -> ItemHandlerHelper.insertItem((IItemHandler)handlerAt, (ItemStack)stack, (boolean)false)).orElseThrow(() -> new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY));
                }
                this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack, (boolean)false)).orElse(ItemStack.field_190927_a);
            }
        }
        return stack;
    }

    public void craftFail(String ticket) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!ticket.equals(request.getTicket())) continue;
            request.setFailed(System.currentTimeMillis() + 2000L);
            this.func_70296_d();
        }
    }

    private void cancelCraft(int index) {
        try {
            this.activeCraftingRequests.remove(index);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startCraft(int index, int amount) {
        Pair<ProcessorTileEntity, ItemStack> pair = this.findCraftableItem(index);
        if (pair == null) {
            System.out.println("What? Can't happen");
            return;
        }
        String ticket = this.getNewTicket(null);
        ItemStack stack = (ItemStack)pair.getValue();
        int count = (amount + stack.func_190916_E() - 1) / stack.func_190916_E();
        CraftingRequest request = new CraftingRequest(ticket, stack, count);
        if (!this.checkRequestAmount()) {
            return;
        }
        this.activeCraftingRequests.add(request);
        ((ProcessorTileEntity)((Object)pair.getKey())).fireCraftEvent(ticket, stack);
        --this.cleanupCounter;
        if (this.cleanupCounter <= 0) {
            this.cleanupCounter = 50;
            this.cleanupStaleRequests();
        }
    }

    private boolean checkRequestAmount() {
        if (this.activeCraftingRequests.size() >= (Integer)Config.maxCraftRequests.get()) {
            this.cleanupCounter = 50;
            this.cleanupStaleRequests();
            if (this.activeCraftingRequests.size() >= (Integer)Config.maxCraftRequests.get()) {
                return false;
            }
        }
        return true;
    }

    public boolean isRequested(Ingredient item) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            long failed = request.getFailed();
            long ok = request.getOk();
            if (failed != -1L || ok != -1L || !item.test(request.getStack())) continue;
            return true;
        }
        return false;
    }

    public boolean request(@Nonnull Ingredient item, @Nullable Inventory destination) {
        for (BlockPos p : this.processorList) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack i : items) {
                if (!item.test(i)) continue;
                String ticket = this.getNewTicket(destination);
                if (!this.checkRequestAmount()) {
                    return false;
                }
                this.activeCraftingRequests.add(new CraftingRequest(ticket, i, 1));
                processor.fireCraftEvent(ticket, i);
                return true;
            }
        }
        return false;
    }

    private String getNewTicket(@Nullable Inventory destInv) {
        ++this.currentTicket;
        this.func_70296_d();
        if (destInv != null) {
            return destInv.serialize() + "#" + this.currentTicket;
        }
        return BlockPosTools.toString((BlockPos)this.field_174879_c) + ":" + this.currentTicket;
    }

    @Nullable
    private Inventory getInventoryFromTicket(String ticket) {
        if (ticket.startsWith("#")) {
            return Inventory.deserialize((String)ticket);
        }
        return null;
    }

    @Nullable
    private BlockPos getPositionFromTicket(String ticket) {
        if (ticket.startsWith("#")) {
            return null;
        }
        String[] splitted = StringUtils.split((String)ticket, (char)';');
        String[] poss = StringUtils.split((String)splitted[0], (char)',');
        return new BlockPos(Integer.parseInt(poss[0]), Integer.parseInt(poss[1]), Integer.parseInt(poss[2]));
    }

    public ItemStackList getCraftableItems() {
        ItemStackList items = ItemStackList.create();
        for (BlockPos p : this.processorList) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            processor.getCraftableItems((List<ItemStack>)items);
        }
        return items;
    }

    private void cleanupStaleRequests() {
        long time = System.currentTimeMillis();
        List<CraftingRequest> oldRequests = this.activeCraftingRequests;
        this.activeCraftingRequests = new ArrayList<CraftingRequest>();
        for (CraftingRequest request : oldRequests) {
            long failed = request.getFailed();
            long ok = request.getOk();
            if (failed != -1L && time > failed || ok != -1L && time > ok) continue;
            this.activeCraftingRequests.add(request);
        }
    }

    public List<CraftingRequest> getRequests() {
        this.cleanupStaleRequests();
        return new ArrayList<CraftingRequest>(this.activeCraftingRequests);
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.readProcessorList(tagCompound);
        this.readRequests(tagCompound);
    }

    protected void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.currentTicket = info.func_74762_e("craftId");
    }

    private void readRequests(CompoundNBT tagCompound) {
        ListNBT list = tagCompound.func_150295_c("requests", 10);
        this.activeCraftingRequests.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT requestTag = list.func_150305_b(i);
            String craftId = requestTag.func_74779_i("craftId");
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)requestTag.func_74775_l("stack"));
            int count = requestTag.func_74762_e("count");
            CraftingRequest request = new CraftingRequest(craftId, stack, count);
            request.setFailed(requestTag.func_74763_f("failed"));
            request.setOk(requestTag.func_74763_f("ok"));
            this.activeCraftingRequests.add(request);
        }
    }

    private void readProcessorList(CompoundNBT tagCompound) {
        ListNBT list = tagCompound.func_150295_c("processors", 10);
        this.processorList.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            this.processorList.add(new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")));
        }
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        this.writeProcessorList(tagCompound);
        this.writeRequests(tagCompound);
    }

    protected void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("craftId", this.currentTicket);
    }

    private void writeRequests(CompoundNBT tagCompound) {
        ListNBT list = new ListNBT();
        for (CraftingRequest request : this.activeCraftingRequests) {
            CompoundNBT requestTag = new CompoundNBT();
            requestTag.func_74778_a("craftId", request.getTicket());
            CompoundNBT stackNbt = new CompoundNBT();
            request.getStack().func_77955_b(stackNbt);
            requestTag.func_218657_a("stack", (INBT)stackNbt);
            requestTag.func_74768_a("count", request.getTodo());
            requestTag.func_74772_a("failed", request.getFailed());
            requestTag.func_74772_a("ok", request.getOk());
            list.add((Object)requestTag);
        }
        tagCompound.func_218657_a("requests", (INBT)list);
    }

    private void writeProcessorList(CompoundNBT tagCompound) {
        ListNBT list = new ListNBT();
        for (BlockPos p : this.processorList) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("x", p.func_177958_n());
            tag.func_74768_a("y", p.func_177956_o());
            tag.func_74768_a("z", p.func_177952_p());
            list.add((Object)tag);
        }
        tagCompound.func_218657_a("processors", (INBT)list);
    }

    private int findItem(String itemName, String nbtString) {
        int index = 0;
        for (BlockPos p : this.processorList) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ItemStackList items = ItemStackList.create();
            processor.getCraftableItems((List<ItemStack>)items);
            for (ItemStack item : items) {
                if (itemName.equals(item.func_77973_b().getRegistryName().toString())) {
                    if (item.func_77942_o()) {
                        if (nbtString.equalsIgnoreCase(item.serializeNBT().toString())) {
                            return index;
                        }
                    } else {
                        return index;
                    }
                }
                ++index;
            }
        }
        return -1;
    }
}

