/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.item;

import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.capability.CapabilityAreaEffect;
import cofh.lib.capability.IAreaEffect;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.item.IColorableItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.ToolTypes;
import cofh.lib.util.helpers.AreaEffectHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.item.EnergyContainerItemAugmentable;
import cofh.thermal.lib.item.IFlexibleEnergyContainerItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class RFSawItem
extends EnergyContainerItemAugmentable
implements IColorableItem,
IDyeableArmorItem,
IMultiModeItem,
IFlexibleEnergyContainerItem {
    protected static final Set<ToolType> TOOL_TYPES = new ObjectOpenHashSet();
    protected static final Set<Material> MATERIALS = new ObjectOpenHashSet();
    protected static final Set<Enchantment> VALID_ENCHANTS = new ObjectOpenHashSet();
    public static final int ENERGY_PER_USE = 200;

    public static void setupEnchants() {
        VALID_ENCHANTS.add(Enchantments.field_185305_q);
        VALID_ENCHANTS.add(Enchantments.field_185306_r);
        VALID_ENCHANTS.add(Enchantments.field_185308_t);
    }

    public RFSawItem(Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder, maxEnergy, maxTransfer);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity) -> this.func_200883_f_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("state"), (stack, world, entity) -> (this.getEnergyStored(stack) > 0 ? 0.5f : 0.0f) + (this.isActive(stack) ? 0.25f : 0.0f));
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "RF", "Area"});
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.cofh.single_block").func_240699_a_(TextFormatting.ITALIC));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.cofh.area").func_240702_b_(": " + radius + "x" + radius).func_240699_a_(TextFormatting.ITALIC));
        }
        if (this.getNumModes(stack) > 1) {
            this.addIncrementModeChangeTooltip(stack, worldIn, tooltip, flagIn);
        }
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || VALID_ENCHANTS.contains(enchantment);
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return TOOL_TYPES.contains(state.getHarvestTool()) ? this.getHarvestLevel(stack) >= state.getHarvestLevel() : MATERIALS.contains(state.func_185904_a());
    }

    /*
     * Enabled aggressive block sorting
     */
    public float func_150893_a(ItemStack stack, BlockState state) {
        float f;
        if (!MATERIALS.contains(state.func_185904_a())) {
            if (!this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0))) {
                f = super.func_150893_a(stack, state);
                return f;
            }
        }
        f = this.getEfficiency(stack);
        return f;
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return this.getToolTypes(stack).contains(tool) ? this.getHarvestLevel(stack) : -1;
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        return TOOL_TYPES;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            float damage = this.getAttackDamage(stack);
            float speed = this.getAttackSpeed(stack);
            if (damage != 0.0f) {
                multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)damage, AttributeModifier.Operation.ADDITION));
            }
            if (speed != 0.0f) {
                multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)speed, AttributeModifier.Operation.ADDITION));
            }
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof PlayerEntity && !((PlayerEntity)attacker).field_71075_bZ.field_75098_d) {
            this.extractEnergy(stack, this.getEnergyPerUse(stack) * 2, false);
        }
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((World)worldIn) && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f && entityLiving instanceof PlayerEntity && !((PlayerEntity)entityLiving).field_71075_bZ.field_75098_d) {
            this.extractEnergy(stack, this.getEnergyPerUse(stack), false);
        }
        return true;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        this.setActive(stack, entity);
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        ItemStack held = context.func_195996_i();
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(pos = context.func_195995_a());
        Block block = (Block)AxeItem.field_203176_a.get(blockstate.func_177230_c());
        if (block != null) {
            PlayerEntity player = context.func_195999_j();
            if (!this.hasEnergy(held) && player != null && !player.field_71075_bZ.field_75098_d) {
                return ActionResultType.PASS;
            }
            world.func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (Utils.isServerWorld((World)world)) {
                world.func_180501_a(pos, (BlockState)block.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, blockstate.func_177229_b((Property)RotatedPillarBlock.field_176298_M)), 11);
                if (player != null && !player.field_71075_bZ.field_75098_d) {
                    this.extractEnergy(held, this.getEnergyPerUse(context.func_195996_i()), false);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.hasActiveTag(stack)) {
            return;
        }
        long activeTime = stack.func_196082_o().func_74763_f("Active");
        if (entityIn.field_70170_p.func_82737_E() > activeTime) {
            stack.func_196082_o().func_82580_o("Active");
        }
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"Radius");
        super.setAttributesFromAugment(container, augmentData);
    }

    protected boolean hasEnergy(ItemStack stack) {
        return this.getEnergyStored(stack) >= this.getEnergyPerUse(stack);
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack) ? 3.0f + this.getBaseMod(stack) : 0.0f;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.hasEnergy(stack) ? -2.1f + this.getBaseMod(stack) / 10.0f : -4.0f;
    }

    protected float getEfficiency(ItemStack stack) {
        return this.hasEnergy(stack) ? 5.0f + this.getBaseMod(stack) : 1.0f;
    }

    protected int getEnergyPerUse(ItemStack stack) {
        return 200;
    }

    protected int getHarvestLevel(ItemStack stack) {
        return this.hasEnergy(stack) ? Math.max(2, (int)this.getBaseMod(stack)) : -1;
    }

    protected int getRadius(ItemStack stack) {
        return (int)AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"Radius", (float)0.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new RFSawItemWrapper(stack, (IEnergyContainerItem)this);
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        super.updateAugmentState(container, augments);
        if (this.getMode(container) >= this.getNumModes(container)) {
            this.setMode(container, this.getNumModes(container) - 1);
        }
    }

    public int getNumModes(ItemStack stack) {
        return 1 + this.getRadius(stack);
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        if (this.getNumModes(stack) <= 1) {
            return;
        }
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.4f, 1.0f - 0.1f * (float)this.getMode(stack));
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.cofh.single_block"));
        } else {
            ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.cofh.area").func_240702_b_(": " + radius + "x" + radius));
        }
    }

    static {
        TOOL_TYPES.add(ToolTypes.SAW);
        TOOL_TYPES.add(ToolType.AXE);
        MATERIALS.add(Material.field_151575_d);
        MATERIALS.add(Material.field_151585_k);
        MATERIALS.add(Material.field_151582_l);
        MATERIALS.add(Material.field_215713_z);
    }

    protected class RFSawItemWrapper
    extends EnergyContainerItemWrapper
    implements IAreaEffect {
        private final LazyOptional<IAreaEffect> holder;

        RFSawItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn) {
            super(containerIn, itemIn, itemIn.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
        }

        public ImmutableList<BlockPos> getAreaEffectBlocks(BlockPos pos, PlayerEntity player) {
            return AreaEffectHelper.getBreakableBlocksRadius((ItemStack)this.container, (BlockPos)pos, (PlayerEntity)player, (int)RFSawItem.this.getMode(this.container));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY) {
                return CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

