/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.shape;

import dev.ftb.mods.ftbultimine.shape.ShapeContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public abstract class Shape {
    private static final Map<String, Shape> MAP = new LinkedHashMap<String, Shape>();
    private static Shape defaultShape;
    public Shape next;
    public Shape prev;

    public static void register(Shape shape) {
        MAP.put(shape.getName(), shape);
        if (shape.isDefault()) {
            defaultShape = shape;
        }
    }

    public static Shape get(String id) {
        if (id.isEmpty()) {
            return defaultShape;
        }
        return MAP.getOrDefault(id, defaultShape);
    }

    public static void postinit() {
        ArrayList<Shape> list = new ArrayList<Shape>(MAP.values());
        for (int i = 0; i < list.size() - 1; ++i) {
            list.get((int)i).next = list.get(i + 1);
            list.get((int)(i + 1)).prev = list.get(i);
        }
        list.get((int)0).prev = list.get(list.size() - 1);
        list.get((int)(list.size() - 1)).next = list.get(0);
    }

    public abstract String getName();

    public abstract List<BlockPos> getBlocks(ShapeContext var1);

    public boolean isDefault() {
        return false;
    }
}

