/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.client.CachedEdge;
import dev.ftb.mods.ftbultimine.client.UltimineRenderTypes;
import dev.ftb.mods.ftbultimine.config.FTBUltimineClientConfig;
import dev.ftb.mods.ftbultimine.event.LevelRenderLastEvent;
import dev.ftb.mods.ftbultimine.net.KeyPressedPacket;
import dev.ftb.mods.ftbultimine.net.ModeChangedPacket;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.utils.ShapeMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.client.ClientLifecycleEvent;
import me.shedaniel.architectury.event.events.client.ClientRawInputEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.registry.KeyBindings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class FTBUltimineClient
extends FTBUltimineCommon {
    private final KeyBinding keyBinding;
    private boolean pressed;
    private boolean canUltimine;
    private List<BlockPos> shapeBlocks = Collections.emptyList();
    private int actualBlocks = 0;
    private List<CachedEdge> cachedEdges = null;
    private BlockPos cachedPos = null;
    public boolean hasScrolled = false;
    private long lastToggle = 0L;
    private final int INPUT_DELAY = 125;
    private final int infoOffset = 0;

    public FTBUltimineClient() {
        this.keyBinding = new KeyBinding("key.ftbultimine", InputMappings.Type.KEYSYM, 96, "key.categories.ftbultimine");
        KeyBindings.registerKeyBinding((KeyBinding)this.keyBinding);
        ClientLifecycleEvent.CLIENT_WORLD_LOAD.register(__ -> FTBUltimineClientConfig.load());
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        GuiEvent.RENDER_HUD.register(this::renderGameOverlay);
        LevelRenderLastEvent.EVENT.register(this::renderInGame);
        ClientRawInputEvent.MOUSE_SCROLLED.register(this::mouseEvent);
        ClientRawInputEvent.KEY_PRESSED.register(this::onKeyPress);
    }

    @Override
    public void setShape(List<BlockPos> blocks) {
        this.actualBlocks = blocks.size();
        int maxRendered = Math.min(this.actualBlocks, (Integer)FTBUltimineClientConfig.renderOutline.get());
        this.shapeBlocks = blocks.subList(0, maxRendered);
        this.cachedEdges = null;
        this.updateEdges();
    }

    public void renderInGame(MatrixStack stack) {
        if (!this.pressed || this.cachedPos == null || this.cachedEdges == null || this.cachedEdges.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!this.canUltimine) {
            return;
        }
        ActiveRenderInfo activeRenderInfo = mc.func_175598_ae().field_217783_c;
        Vector3d projectedView = activeRenderInfo.func_216785_c();
        stack.func_227860_a_();
        stack.func_227861_a_((double)this.cachedPos.func_177958_n() - projectedView.field_72450_a, (double)this.cachedPos.func_177956_o() - projectedView.field_72448_b, (double)this.cachedPos.func_177952_p() - projectedView.field_72449_c);
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        IVertexBuilder buffer = mc.func_228019_au_().func_228487_b_().getBuffer(UltimineRenderTypes.LINES_NORMAL);
        for (CachedEdge edge : this.cachedEdges) {
            buffer.func_227888_a_(matrix, edge.x1, edge.y1, edge.z1).func_225586_a_(255, 255, 255, 255).func_181675_d();
            buffer.func_227888_a_(matrix, edge.x2, edge.y2, edge.z2).func_225586_a_(255, 255, 255, 255).func_181675_d();
        }
        mc.func_228019_au_().func_228487_b_().func_228462_a_(UltimineRenderTypes.LINES_NORMAL);
        IVertexBuilder buffer2 = mc.func_228019_au_().func_228487_b_().getBuffer(UltimineRenderTypes.LINES_TRANSPARENT);
        for (CachedEdge edge : this.cachedEdges) {
            buffer2.func_227888_a_(matrix, edge.x1, edge.y1, edge.z1).func_225586_a_(255, 255, 255, 10).func_181675_d();
            buffer2.func_227888_a_(matrix, edge.x2, edge.y2, edge.z2).func_225586_a_(255, 255, 255, 10).func_181675_d();
        }
        mc.func_228019_au_().func_228487_b_().func_228462_a_(UltimineRenderTypes.LINES_TRANSPARENT);
        stack.func_227865_b_();
    }

    public ActionResultType mouseEvent(Minecraft client, double amount) {
        if (this.pressed && amount != 0.0 && this.sneak()) {
            this.hasScrolled = true;
            new ModeChangedPacket(amount < 0.0).sendToServer();
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType onKeyPress(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        if (System.currentTimeMillis() - this.lastToggle < 125L) {
            return ActionResultType.PASS;
        }
        if (keyCode != 265 && keyCode != 264) {
            return ActionResultType.PASS;
        }
        if (!this.pressed || !this.sneak()) {
            return ActionResultType.PASS;
        }
        this.hasScrolled = true;
        new ModeChangedPacket(keyCode == 264).sendToServer();
        this.lastToggle = System.currentTimeMillis();
        return ActionResultType.PASS;
    }

    private boolean sneak() {
        return this.keyBinding.field_74512_d.func_197937_c() == 340 || this.keyBinding.field_74512_d.func_197937_c() == 344 ? Screen.func_231172_r_() : Screen.func_231173_s_();
    }

    private void addPressedInfo(List<IFormattableTextComponent> list) {
        list.add((IFormattableTextComponent)new TranslationTextComponent("ftbultimine.info.base", new Object[]{this.canUltimine ? new TranslationTextComponent("ftbultimine.info.active").func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)10731148))) : new TranslationTextComponent("ftbultimine.info.not_active").func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)12542314)))}));
        if (!this.hasScrolled) {
            list.add(new TranslationTextComponent("ftbultimine.change_shape").func_240699_a_(TextFormatting.GRAY));
        }
        if (SendShapePacket.current != null) {
            if (this.sneak()) {
                list.add((IFormattableTextComponent)new StringTextComponent(""));
                list.add(new StringTextComponent("^ ").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new TranslationTextComponent("ftbultimine.shape." + SendShapePacket.current.prev.getName())));
            }
            IFormattableTextComponent mining = new StringTextComponent("- ").func_230529_a_((ITextComponent)new TranslationTextComponent("ftbultimine.shape." + SendShapePacket.current.getName()));
            if (this.canUltimine && this.actualBlocks != 0) {
                mining.func_240702_b_(" (").func_230529_a_((ITextComponent)new TranslationTextComponent("ftbultimine.info.blocks", new Object[]{this.actualBlocks}));
                if (this.actualBlocks > this.shapeBlocks.size()) {
                    mining.func_240702_b_(", ").func_230529_a_((ITextComponent)new TranslationTextComponent("ftbultimine.info.partial_render", new Object[]{this.shapeBlocks.size()}));
                }
                mining.func_240702_b_(")");
            }
            list.add(mining);
            if (this.sneak()) {
                list.add(new StringTextComponent("v ").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new TranslationTextComponent("ftbultimine.shape." + SendShapePacket.current.next.getName())));
            }
        }
    }

    public void renderGameOverlay(MatrixStack matrices, float tickDelta) {
        if (this.pressed) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
            this.addPressedInfo(list);
            Minecraft minecraft = Minecraft.func_71410_x();
            Objects.requireNonNull(minecraft.field_71466_p);
            int top = 2 + 9 * 0;
            for (IFormattableTextComponent msg : list) {
                IReorderingProcessor formatted = msg.func_241878_f();
                int n = 2 + minecraft.field_71466_p.func_243245_a(formatted) + 1;
                Objects.requireNonNull(minecraft.field_71466_p);
                AbstractGui.func_238467_a_((MatrixStack)matrices, (int)1, (int)(top - 1), (int)n, (int)(top + 9 - 1), (int)-1439812544);
                minecraft.field_71466_p.func_238407_a_(matrices, formatted, 2.0f, (float)top, 15527924);
                Objects.requireNonNull(minecraft.field_71466_p);
                top += 9;
            }
        }
    }

    public void clientTick(Minecraft mc) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        boolean p = this.pressed;
        this.pressed = this.keyBinding.func_151470_d();
        if (this.pressed != p) {
            new KeyPressedPacket(this.pressed).sendToServer();
        }
        this.canUltimine = this.pressed && FTBUltimine.instance.canUltimine((PlayerEntity)mc.field_71439_g);
    }

    private void updateEdges() {
        if (this.cachedEdges != null) {
            return;
        }
        if (this.shapeBlocks.isEmpty()) {
            this.cachedEdges = Collections.emptyList();
            return;
        }
        this.cachedPos = this.shapeBlocks.get(0);
        double d = 0.005;
        this.cachedEdges = new ArrayList<CachedEdge>();
        HashSet<VoxelShape> shapes = new HashSet<VoxelShape>();
        for (AxisAlignedBB aabb : ShapeMerger.merge(this.shapeBlocks, this.cachedPos)) {
            shapes.add(VoxelShapes.func_197881_a((AxisAlignedBB)aabb.func_186662_g(d)));
        }
        FTBUltimineClient.orShapes(shapes).func_197754_a((x1, y1, z1, x2, y2, z2) -> {
            CachedEdge edge = new CachedEdge();
            edge.x1 = (float)x1;
            edge.y1 = (float)y1;
            edge.z1 = (float)z1;
            edge.x2 = (float)x2;
            edge.y2 = (float)y2;
            edge.z2 = (float)z2;
            this.cachedEdges.add(edge);
        });
    }

    static VoxelShape orShapes(Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = VoxelShapes.func_197880_a();
        for (VoxelShape shape : shapes) {
            combinedShape = VoxelShapes.func_197882_b((VoxelShape)combinedShape, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return combinedShape;
    }
}

