/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.screen.IScreenAddonConsumer;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.client.screen.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponentHarness;
import com.hrznstudio.titanium.component.sideness.SidedComponentManager;
import com.hrznstudio.titanium.container.IDisableableContainer;
import com.hrznstudio.titanium.container.IObjectContainer;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.hrznstudio.titanium.util.FacingUtil;
import com.hrznstudio.titanium.util.LangUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class FacingHandlerScreenAddon
extends BasicScreenAddon
implements IClickable {
    private final IFacingComponent handler;
    private List<StateButtonAddon> buttonAddons;
    private int xSize;
    private int ySize;
    private boolean clicked;
    private Point inventoryPoint;
    private IAssetType<?> assetType;
    private Direction blockDirection;

    public FacingHandlerScreenAddon(SidedComponentManager manager, IFacingComponent facingHandler, IAssetType<?> assetType, Direction blockDirection) {
        super(manager.getPosX(), manager.getPosY());
        this.handler = facingHandler;
        this.buttonAddons = new ArrayList<StateButtonAddon>();
        this.xSize = 0;
        this.ySize = 0;
        this.clicked = false;
        this.assetType = assetType;
        this.blockDirection = blockDirection;
    }

    public static Point getPointFromFacing(FacingUtil.Sideness sideness, Point inventory) {
        Point origin = new Point(inventory.x + 73, inventory.y + 19);
        switch (sideness) {
            case TOP: {
                origin.translate(0, -16);
                break;
            }
            case BOTTOM: {
                origin.translate(0, 16);
                break;
            }
            case LEFT: {
                origin.translate(-16, 0);
                break;
            }
            case RIGHT: {
                origin.translate(16, 0);
                break;
            }
            case BACK: {
                origin.translate(16, 16);
            }
        }
        return origin;
    }

    @Override
    public void drawBackgroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        IBackgroundAsset backgroundInfo = provider.getAsset(AssetTypes.BACKGROUND);
        this.inventoryPoint = backgroundInfo.getInventoryPosition();
        this.xSize = provider.getAsset(AssetTypes.BUTTON_SIDENESS_MANAGER).getArea().width;
        this.ySize = provider.getAsset(AssetTypes.BUTTON_SIDENESS_MANAGER).getArea().height;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AssetUtil.drawAsset(stack, screen, provider.getAsset(AssetTypes.BUTTON_SIDENESS_MANAGER), guiX + this.getPosX(), guiY + this.getPosY());
        int offset = 2;
        AbstractGui.func_238467_a_((MatrixStack)stack, (int)(guiX + this.getPosX() + offset), (int)(guiY + this.getPosY() + offset), (int)(guiX + this.getPosX() + this.getXSize() - offset), (int)(guiY + this.getPosY() + this.getYSize() - offset), (int)this.handler.getColor());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isClicked()) {
            screen.func_238474_b_(stack, guiX + backgroundInfo.getInventoryPosition().x - 1, guiY + backgroundInfo.getInventoryPosition().y - 1, 16, 231, 14, 14);
            screen.func_238474_b_(stack, guiX + backgroundInfo.getInventoryPosition().x - 1, guiY + backgroundInfo.getInventoryPosition().y - 1, 56, 185, 162, 54);
        }
    }

    @Override
    public void drawForegroundLayer(MatrixStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        if (this.isInside(screen, mouseX - guiX, mouseY - guiY)) {
            AssetUtil.drawSelectingOverlay(stack, this.getPosX() + 1, this.getPosY() + 1, this.getPosX() + this.getXSize() - 1, this.getPosY() + this.getYSize() - 1);
        }
        if (this.isInside(screen, mouseX - guiX, mouseY - guiY) || this.isClicked()) {
            Object asset = provider.getAsset(this.assetType);
            Rectangle area = this.handler.getRectangle((IAsset)asset);
            AssetUtil.drawHorizontalLine(stack, area.x, area.x + area.width, area.y, this.handler.getColor());
            AssetUtil.drawHorizontalLine(stack, area.x, area.x + area.width, area.y + area.height, this.handler.getColor());
            AssetUtil.drawVerticalLine(stack, area.x, area.y, area.y + area.height, this.handler.getColor());
            AssetUtil.drawVerticalLine(stack, area.x + area.width, area.y, area.y + area.height, this.handler.getColor());
        }
    }

    @Override
    public List<ITextComponent> getTooltipLines() {
        return Collections.singletonList(LangUtil.get("tooltip.titanium.facing_handler." + this.handler.getName().toLowerCase(), new Object[0]));
    }

    @Override
    public int getXSize() {
        return this.xSize;
    }

    @Override
    public int getYSize() {
        return this.ySize;
    }

    @Override
    public void handleClick(Screen screen, int guiX, int guiY, double mouseX, double mouseY, int button) {
        if (button == 1) {
            return;
        }
        if (screen instanceof IScreenAddonConsumer && screen instanceof IHasContainer) {
            IScreenAddonConsumer screenAddonConsumer = (IScreenAddonConsumer)screen;
            final Container container = ((IHasContainer)screen).func_212873_a_();
            Consumer<Boolean> disable = container instanceof IDisableableContainer ? ((IDisableableContainer)container)::setDisabled : value -> {};
            for (IScreenAddon addon : new ArrayList<IScreenAddon>(((IScreenAddonConsumer)screen).getAddons())) {
                if (!(addon instanceof FacingHandlerScreenAddon) || addon == this) continue;
                ((FacingHandlerScreenAddon)addon).setClicked(screenAddonConsumer, disable, false);
                disable.accept(true);
            }
            this.setClicked(screenAddonConsumer, disable, !this.clicked);
            if (this.clicked) {
                disable.accept(true);
                for (final FacingUtil.Sideness facing : FacingUtil.Sideness.values()) {
                    if (!this.handler.getFacingModes().containsKey((Object)facing)) continue;
                    Point point = FacingHandlerScreenAddon.getPointFromFacing(facing, this.inventoryPoint);
                    ArrayList<StateButtonInfo> stateButtonInfo = new ArrayList<StateButtonInfo>();
                    for (int i = 0; i < this.handler.getValidFacingModes().length; ++i) {
                        stateButtonInfo.add(this.handler.getValidFacingModes()[i].getInfo(i));
                    }
                    StateButtonAddon addon = new StateButtonAddon(new ButtonComponent(point.x, point.y, 14, 14), stateButtonInfo.toArray(new StateButtonInfo[0])){

                        @Override
                        public int getState() {
                            IFacingComponent handler = null;
                            if (container instanceof IObjectContainer) {
                                Object containedObject = ((IObjectContainer)container).getObject();
                                if (containedObject instanceof IFacingComponentHarness) {
                                    handler = ((IFacingComponentHarness)containedObject).getHandlerFromName(FacingHandlerScreenAddon.this.handler.getName());
                                } else {
                                    Titanium.LOGGER.warn("Contained Object is not IFacingComponentHarness. Could not get FacingComponent");
                                }
                            } else {
                                Titanium.LOGGER.warn("Container is not IObjectContainer. Could not get FacingComponent");
                            }
                            return handler != null && handler.getFacingModes().containsKey((Object)facing) ? Arrays.asList(handler.getValidFacingModes()).indexOf((Object)handler.getFacingModes().get((Object)facing)) : 0;
                        }

                        @Override
                        public void handleClick(Screen gui, int guiX, int guiY, double mouseX, double mouseY, int mouse) {
                            StateButtonInfo info = this.getStateInfo();
                            if (info != null && gui instanceof IHasContainer) {
                                CompoundNBT compound = new CompoundNBT();
                                compound.func_74778_a("Facing", facing.name());
                                int faceMode = (this.getState() + (mouse == 0 ? 1 : -1)) % FacingHandlerScreenAddon.this.handler.getValidFacingModes().length;
                                if (faceMode < 0) {
                                    faceMode = FacingHandlerScreenAddon.this.handler.getValidFacingModes().length - 1;
                                }
                                compound.func_74768_a("Next", faceMode);
                                compound.func_74778_a("Name", FacingHandlerScreenAddon.this.handler.getName());
                                if (container instanceof ILocatable) {
                                    Titanium.NETWORK.get().sendToServer((Object)new ButtonClickNetworkMessage(((ILocatable)container).getLocatorInstance(), -1, compound));
                                } else {
                                    Titanium.LOGGER.warn("Failed to Find Locatable Instance for Container");
                                }
                                FacingHandlerScreenAddon.this.handler.getFacingModes().put(facing, FacingHandlerScreenAddon.this.handler.getValidFacingModes()[faceMode]);
                            }
                        }

                        @Override
                        public List<ITextComponent> getTooltipLines() {
                            ArrayList<ITextComponent> strings = new ArrayList<ITextComponent>();
                            IFacingComponent.FaceMode mode = FacingHandlerScreenAddon.this.handler.getValidFacingModes()[this.getState()];
                            strings.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString("tooltip.titanium.facing_handler.direction", new Object[0]) + TextFormatting.RESET + LangUtil.getString("tooltip.titanium.facing_handler." + facing.name().toLowerCase(), new Object[0]) + TextFormatting.GRAY + " [" + LangUtil.getString("direction.titanium." + FacingUtil.getFacingFromSide(FacingHandlerScreenAddon.this.blockDirection, facing), new Object[0]) + "]"));
                            strings.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + LangUtil.getString("tooltip.titanium.facing_handler.action", new Object[0]) + mode.getColor() + this.getStateInfo().getTooltip()[0].getString()));
                            return strings;
                        }
                    };
                    this.buttonAddons.add(addon);
                    ((IScreenAddonConsumer)screen).getAddons().add(addon);
                }
            }
        }
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public void setClicked(IScreenAddonConsumer information, Consumer<Boolean> disable, boolean clicked) {
        this.clicked = clicked;
        if (!clicked) {
            information.getAddons().removeIf(iGuiAddon -> this.buttonAddons.contains(iGuiAddon));
            this.buttonAddons.clear();
            disable.accept(false);
        }
    }
}

