/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import ipsis.woot.util.helper.WorldHelper;
import java.util.HashMap;
import java.util.List;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class WootMachineTileEntity
extends TileEntity
implements ITickableTileEntity {
    protected HashMap<Direction, Mode> settings = new HashMap();
    protected static final Logger LOGGER = LogManager.getLogger();
    private boolean isActive = false;
    private int processMax = 0;
    private int processRem = 0;

    public WootMachineTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        for (Direction direction : Direction.values()) {
            this.settings.put(direction, Mode.NONE);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.machineTick();
    }

    private void machineTick() {
        if (this.isActive) {
            this.processTick();
            if (this.canFinish()) {
                this.processFinish();
                if (this.isDisabled() || !this.canStart()) {
                    this.processOff();
                    this.isActive = false;
                } else {
                    this.processStart();
                }
            } else if (!this.hasEnergy()) {
                this.processOff();
            }
        } else if (!this.isDisabled() && this.field_145850_b.func_82737_E() % 10L == 0L && this.canStart()) {
            this.processStart();
            this.processTick();
            this.isActive = true;
        }
    }

    protected abstract boolean canStart();

    protected abstract void processFinish();

    protected abstract boolean hasValidInput();

    protected abstract boolean hasEnergy();

    protected abstract int useEnergy();

    protected abstract void clearRecipe();

    protected abstract int getRecipeEnergy();

    protected abstract boolean isDisabled();

    private int processTick() {
        if (this.processRem <= 0) {
            return 0;
        }
        int energy = this.useEnergy();
        this.processRem -= energy;
        return energy;
    }

    private boolean canFinish() {
        return this.processRem <= 0 && this.hasValidInput();
    }

    protected int calculateProgress() {
        return this.processMax == 0 ? 0 : 100 - (int)(100.0f / (float)this.processMax * (float)this.processRem);
    }

    protected void processOff() {
        this.isActive = false;
        this.processRem = 0;
        this.processMax = 0;
        this.clearRecipe();
    }

    private void processStart() {
        this.processMax = this.getRecipeEnergy();
        this.processRem = this.getRecipeEnergy();
    }

    public void onContentsChanged(int slot) {
        if (!this.isActive) {
            return;
        }
        if (!this.hasValidInput()) {
            this.processOff();
        }
    }

    public void dropContents(List<ItemStack> items) {
        for (ItemStack itemStack : items) {
            if (itemStack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)itemStack);
        }
        this.func_70296_d();
        WorldHelper.updateClient(this.field_145850_b, this.field_174879_c);
    }

    protected static enum Mode {
        NONE,
        INPUT,
        OUTPUT;

    }
}

