/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.library;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ipsis.woot.Woot;
import ipsis.woot.simulator.DropStackData;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.simulator.library.SimulatedMob;
import ipsis.woot.util.helper.JsonHelper;
import ipsis.woot.util.helper.MathHelper;
import ipsis.woot.util.helper.RandomHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.crafting.CraftingHelper;

public class SimulatedMobDrop {
    protected ItemStack itemStack;
    protected int[] simulatedDropCount;
    protected float[] customChanceToDrop;
    protected boolean hasCustom;
    protected SimulatedMob simulatedMob;
    protected List<HashMap<Integer, Integer>> simulatedStackSize;
    protected List<HashMap<Integer, Integer>> customStackSize;
    private static final String TAG_DROPPED_ITEM = "drop";
    private static final String TAG_SIM_KILLS = "simulatedCount";
    private static final String[] TAG_STACK_SIZES = new String[]{"stack0", "stack1", "stack2", "stack3"};

    private SimulatedMobDrop() {
    }

    public SimulatedMobDrop(ItemStack itemStack, SimulatedMob simulatedMob) {
        this.simulatedMob = simulatedMob;
        this.hasCustom = false;
        this.itemStack = itemStack.func_77946_l();
        this.simulatedDropCount = new int[]{0, 0, 0, 0};
        this.customChanceToDrop = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        this.simulatedStackSize = new ArrayList<HashMap<Integer, Integer>>(4);
        this.customStackSize = new ArrayList<HashMap<Integer, Integer>>(4);
        for (int i = 0; i < 4; ++i) {
            this.simulatedStackSize.add(i, new HashMap());
            this.customStackSize.add(i, new HashMap());
        }
    }

    public String toString() {
        return "SimulatedMobDrop{itemStack=" + this.itemStack + ", simulatedDropCount=" + Arrays.toString(this.simulatedDropCount) + ", customChanceToDrop=" + Arrays.toString(this.customChanceToDrop) + ", hasCustom=" + this.hasCustom + ", simulatedMob=" + this.simulatedMob + ", simulatedStackSize=" + this.simulatedStackSize + ", customStackSize=" + this.customStackSize + '}';
    }

    private float calculateDropChance(int looting) {
        looting = MathHelper.clampLooting(looting);
        if (this.hasCustom) {
            return this.customChanceToDrop[looting];
        }
        float dropChance = 0.0f;
        if (this.simulatedMob.getSimulatedKills(looting) > 0) {
            dropChance = 100.0f / (float)this.simulatedMob.getSimulatedKills(looting) * (float)this.simulatedDropCount[looting];
        }
        return dropChance;
    }

    private int calculateDropSize(int looting) {
        int stackSize = 1;
        looting = MathHelper.clampLooting(looting);
        HashMap<Integer, Integer> stackWeights = this.hasCustom ? this.customStackSize.get(looting) : this.simulatedStackSize.get(looting);
        if (!stackWeights.isEmpty()) {
            ArrayList<DropStackData> dropstacks = new ArrayList<DropStackData>();
            for (Map.Entry<Integer, Integer> entry : stackWeights.entrySet()) {
                dropstacks.add(new DropStackData(entry.getKey(), entry.getValue()));
            }
            if (WeightedRandom.func_76272_a(dropstacks) > 0) {
                DropStackData chosen = (DropStackData)WeightedRandom.func_76271_a((Random)RandomHelper.RANDOM, dropstacks);
                stackSize = chosen.stackSize;
            }
        }
        return stackSize;
    }

    public void addSimulatedData(int looting, int stackSize) {
        int n = looting = MathHelper.clampLooting(looting);
        this.simulatedDropCount[n] = this.simulatedDropCount[n] + 1;
        Integer count = this.simulatedStackSize.get(looting).getOrDefault(stackSize, 0);
        this.simulatedStackSize.get(looting).put(stackSize, count + 1);
    }

    public void addCustomDrop(int looting, float dropChance, HashMap<Integer, Integer> stackSizes) {
        looting = MathHelper.clampLooting(looting);
        this.customChanceToDrop[looting] = dropChance;
        this.hasCustom = true;
        Woot.setup.getLogger().debug("SimulatedMobDrop looting:{} {} custom drop chance:{}", (Object)looting, (Object)this.itemStack, (Object)Float.valueOf(dropChance));
        for (Map.Entry<Integer, Integer> entry : stackSizes.entrySet()) {
            this.customStackSize.get(looting).put(entry.getKey(), entry.getValue());
            Woot.setup.getLogger().debug("SimulatedMobDrop custom drop size {} weight:{}", (Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    public SimulatedMobDropSummary createSummary() {
        return new SimulatedMobDropSummary(this.itemStack.func_77946_l(), this.calculateDropChance(0), this.calculateDropChance(1), this.calculateDropChance(2), this.calculateDropChance(3));
    }

    @Nonnull
    public ItemStack getRolledDrop(int looting) {
        ItemStack dropStack = ItemStack.field_190927_a;
        float dropChance = this.calculateDropChance(looting);
        if (RandomHelper.rollPercentage(dropChance, "getRolledDrop")) {
            dropStack = this.itemStack.func_77946_l();
            dropStack.func_190920_e(this.calculateDropSize(looting));
        }
        return dropStack;
    }

    public JsonObject toJson() {
        int i;
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(TAG_DROPPED_ITEM, (JsonElement)JsonHelper.toJsonObject(this.itemStack));
        JsonArray simulatedArray = new JsonArray();
        for (i = 0; i < 4; ++i) {
            simulatedArray.add((Number)this.simulatedDropCount[i]);
        }
        jsonObject.add(TAG_SIM_KILLS, (JsonElement)simulatedArray);
        for (i = 0; i < 4; ++i) {
            JsonArray stackArray = new JsonArray();
            for (Map.Entry<Integer, Integer> e : this.simulatedStackSize.get(i).entrySet()) {
                stackArray.add((Number)e.getKey());
                stackArray.add((Number)e.getValue());
            }
            jsonObject.add(TAG_STACK_SIZES[i], (JsonElement)stackArray);
        }
        return jsonObject;
    }

    @Nullable
    public static SimulatedMobDrop fromJson(SimulatedMob simulatedMob, JsonObject jsonObject) {
        int i;
        ItemStack itemStack;
        try {
            itemStack = CraftingHelper.getItemStack((JsonObject)jsonObject.getAsJsonObject(TAG_DROPPED_ITEM), (boolean)false);
        }
        catch (JsonSyntaxException e) {
            Woot.setup.getLogger().error("Failed to parse itemstack");
            return null;
        }
        JsonArray dropsArray = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)TAG_SIM_KILLS);
        if (dropsArray.size() != 4) {
            throw new JsonSyntaxException("Simulated count array must be of size 4");
        }
        SimulatedMobDrop simulatedMobDrop = new SimulatedMobDrop(itemStack, simulatedMob);
        for (i = 0; i < 4; ++i) {
            simulatedMobDrop.simulatedDropCount[i] = dropsArray.get(i).getAsInt();
        }
        for (i = 0; i < 4; ++i) {
            JsonArray sizesArray = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)TAG_STACK_SIZES[i]);
            if (sizesArray.size() <= 0 || sizesArray.size() % 2 != 0) continue;
            for (int j = 0; j < sizesArray.size() / 2; j += 2) {
                int size = sizesArray.get(j).getAsInt();
                int count = sizesArray.get(j + 1).getAsInt();
                simulatedMobDrop.simulatedStackSize.get(i).put(size, count);
            }
        }
        return simulatedMobDrop;
    }
}

