/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.setup;

import io.netty.buffer.ByteBuf;
import ipsis.woot.modules.factory.blocks.HeartTileEntity;
import ipsis.woot.modules.oracle.blocks.OracleTileEntity;
import ipsis.woot.modules.oracle.network.SimulatedMobDropsSummaryReply;
import ipsis.woot.modules.oracle.network.SimulatedMobsReply;
import ipsis.woot.setup.NetworkChannel;
import ipsis.woot.util.oss.NetworkTools;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class ServerDataRequest {
    public String s;
    public BlockPos pos;
    public Type requestType;

    public ServerDataRequest(Type requestType, BlockPos pos, String s) {
        this.requestType = requestType;
        this.pos = new BlockPos((Vector3i)pos);
        this.s = s;
    }

    public static ServerDataRequest fromBytes(ByteBuf buf) {
        return new ServerDataRequest(Type.fromIndex(buf.readInt()), new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()), NetworkTools.readString(buf));
    }

    public void toByte(ByteBuf buf) {
        buf.writeInt(this.requestType.ordinal());
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        NetworkTools.writeString(buf, this.s);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity serverPlayerEntity = ctx.get().getSender();
        if (serverPlayerEntity != null) {
            ctx.get().enqueueWork(() -> {
                TileEntity te = serverPlayerEntity.field_70170_p.func_175625_s(this.pos);
                if (this.requestType == Type.DROP_REGISTRY_STATUS) {
                    if (te instanceof OracleTileEntity) {
                        NetworkChannel.channel.sendTo((Object)new SimulatedMobsReply(), serverPlayerEntity.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                    }
                } else if (this.requestType == Type.SIMULATED_MOB_DROPS) {
                    if (te instanceof OracleTileEntity) {
                        NetworkChannel.channel.sendTo((Object)SimulatedMobDropsSummaryReply.fromMob(this.s), serverPlayerEntity.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                    }
                } else if (this.requestType == Type.HEART_STATIC_DATA && te instanceof HeartTileEntity) {
                    NetworkChannel.channel.sendTo((Object)((HeartTileEntity)te).createStaticDataReply2(), serverPlayerEntity.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                    ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                }
            });
        }
    }

    public String toString() {
        return (Object)((Object)this.requestType) + " " + this.pos.toString() + "(" + this.s + ")";
    }

    public static enum Type {
        HEART_STATIC_DATA,
        DROP_REGISTRY_STATUS,
        SIMULATED_MOB_DROPS;

        static Type[] VALUES;

        public static Type fromIndex(int index) {
            index = MathHelper.func_76125_a((int)index, (int)0, (int)(VALUES.length - 1));
            return VALUES[index];
        }

        static {
            VALUES = Type.values();
        }
    }
}

