/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.squeezer.blocks;

import ipsis.woot.crafting.DyeSqueezerRecipe;
import ipsis.woot.fluilds.network.TankPacket;
import ipsis.woot.modules.squeezer.SqueezerSetup;
import ipsis.woot.modules.squeezer.blocks.DyeSqueezerTileEntity;
import ipsis.woot.setup.NetworkChannel;
import ipsis.woot.util.TankPacketHandler;
import ipsis.woot.util.WootContainer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class DyeSqueezerContainer
extends WootContainer
implements TankPacketHandler {
    public DyeSqueezerTileEntity tileEntity;
    private int red = 0;
    private int yellow = 0;
    private int blue = 0;
    private int white = 0;
    private int progress = 0;
    private FluidStack pureDye = FluidStack.EMPTY;
    private int energy = 0;
    private boolean dumpExcess = false;

    public DyeSqueezerContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        super((ContainerType)SqueezerSetup.SQUEEZER_BLOCK_CONTAINER.get(), windowId);
        this.tileEntity = (DyeSqueezerTileEntity)world.func_175625_s(pos);
        this.addOwnSlots(this.tileEntity.getInventory());
        this.addPlayerSlots((IInventory)playerInventory);
        this.addListeners();
    }

    private void addOwnSlots(IItemHandler inv) {
        this.func_75146_a((Slot)new SlotItemHandler(inv, 0, 39, 40));
    }

    private void addPlayerSlots(IInventory playerInventory) {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 10 + col * 18;
                int y = row * 18 + 95;
                this.func_75146_a(new Slot(playerInventory, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 10 + row * 18;
            this.func_75146_a(new Slot(playerInventory, row, x, 153));
        }
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        return DyeSqueezerContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)playerIn, (Block)((Block)SqueezerSetup.SQUEEZER_BLOCK.get()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        int endIndex;
        int startIndex;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack stackCopy = stack.func_77946_l();
        boolean MACHINE_INV_SIZE = true;
        int PLAYER_INV_SIZE = 27;
        int TOOLBAR_INV_SIZE = 9;
        if (index >= 1) {
            if (DyeSqueezerRecipe.isValidInput(stack)) {
                startIndex = 0;
                endIndex = 1;
            } else if (index < 28) {
                startIndex = 28;
                endIndex = startIndex + 9;
            } else {
                if (index < 28) return ItemStack.field_190927_a;
                startIndex = 1;
                endIndex = startIndex + 27;
            }
        } else {
            startIndex = 1;
            endIndex = startIndex + 27 + 9;
        }
        if (!this.func_75135_a(stack, startIndex, endIndex, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190916_E() == 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        if (stack.func_190916_E() == stackCopy.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_190901_a(playerIn, stack);
        return stackCopy;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRedDyeAmount() {
        return this.red;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getYellowDyeAmount() {
        return this.yellow;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBlueDyeAmount() {
        return this.blue;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getWhiteDyeAmount() {
        return this.white;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgress() {
        return this.progress;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getPureDye() {
        return this.pureDye;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergy() {
        return this.energy;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getDumpExcess() {
        return this.dumpExcess;
    }

    public void addListeners() {
        this.addShortListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return DyeSqueezerContainer.this.tileEntity.getRed();
            }

            public void func_221494_a(int i) {
                DyeSqueezerContainer.this.red = i;
            }
        });
        this.addShortListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return DyeSqueezerContainer.this.tileEntity.getBlue();
            }

            public void func_221494_a(int i) {
                DyeSqueezerContainer.this.blue = i;
            }
        });
        this.addShortListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return DyeSqueezerContainer.this.tileEntity.getWhite();
            }

            public void func_221494_a(int i) {
                DyeSqueezerContainer.this.white = i;
            }
        });
        this.addShortListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return DyeSqueezerContainer.this.tileEntity.getYellow();
            }

            public void func_221494_a(int i) {
                DyeSqueezerContainer.this.yellow = i;
            }
        });
        this.addIntegerListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return DyeSqueezerContainer.this.tileEntity.getEnergy();
            }

            public void func_221494_a(int i) {
                DyeSqueezerContainer.this.energy = i;
            }
        });
        this.addShortListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return DyeSqueezerContainer.this.tileEntity.getProgress();
            }

            public void func_221494_a(int i) {
                DyeSqueezerContainer.this.progress = i;
            }
        });
        this.addShortListener(new IntReferenceHolder(){

            public int func_221495_b() {
                return DyeSqueezerContainer.this.tileEntity.getDumpExcess() ? 1 : 0;
            }

            public void func_221494_a(int i) {
                DyeSqueezerContainer.this.dumpExcess = i == 1;
            }
        });
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.pureDye.isFluidStackIdentical(this.tileEntity.getOutputTankFluid())) {
            this.pureDye = this.tileEntity.getOutputTankFluid().copy();
            for (IContainerListener l : this.field_75149_d) {
                if (!(l instanceof ServerPlayerEntity)) continue;
                NetworkChannel.channel.sendTo((Object)this.tileEntity.getOutputTankPacket(), ((ServerPlayerEntity)l).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @Override
    public void handlePacket(TankPacket packet) {
        if (packet.tankId == 0) {
            this.pureDye = packet.fluidStack;
        }
    }
}

