/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.oracle.blocks;

import ipsis.woot.modules.oracle.OracleSetup;
import ipsis.woot.modules.oracle.network.SimulatedMobDropsSummaryReply;
import ipsis.woot.modules.oracle.network.SimulatedMobsReply;
import ipsis.woot.setup.NetworkChannel;
import ipsis.woot.setup.ServerDataRequest;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.util.FakeMob;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OracleContainer
extends Container {
    public TileEntity tileEntity;
    public List<FakeMob> simulatedMobs = new ArrayList<FakeMob>();
    public List<SimulatedMobDropSummary> simulatedDrops = new ArrayList<SimulatedMobDropSummary>();

    public OracleContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        super((ContainerType)OracleSetup.ORACLE_BLOCK_CONTAINER.get(), windowId);
        this.tileEntity = world.func_175625_s(pos);
    }

    public BlockPos getPos() {
        return this.tileEntity.func_174877_v();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return OracleContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)playerIn, (Block)((Block)OracleSetup.ORACLE_BLOCK.get()));
    }

    public void refreshMobs() {
        NetworkChannel.channel.sendToServer((Object)new ServerDataRequest(ServerDataRequest.Type.DROP_REGISTRY_STATUS, this.getPos(), ""));
        this.simulatedMobs.clear();
        this.simulatedDrops.clear();
    }

    public void refreshDrops(int index) {
        if (this.simulatedMobs.size() > index) {
            NetworkChannel.channel.sendToServer((Object)new ServerDataRequest(ServerDataRequest.Type.SIMULATED_MOB_DROPS, this.getPos(), this.simulatedMobs.get(index).getName()));
        }
        this.simulatedDrops.clear();
    }

    public void handleSimulatedMobsReply(SimulatedMobsReply msg) {
        this.simulatedMobs.clear();
        this.simulatedMobs.addAll(msg.simulatedMobs);
        if (!this.simulatedMobs.isEmpty()) {
            this.refreshDrops(0);
        }
    }

    public void handleSimulatedMobDropsSummaryReply(SimulatedMobDropsSummaryReply msg) {
        this.simulatedDrops.clear();
        this.simulatedDrops.addAll(msg.drops);
    }
}

