/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.layout.items;

import ipsis.woot.Woot;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.HeartBlock;
import ipsis.woot.modules.factory.layout.FactoryHelper;
import ipsis.woot.modules.factory.layout.PatternRepository;
import ipsis.woot.util.helper.StringHelper;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InternItem
extends Item {
    private static final String NBT_MODE = "mode";

    public InternItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(Woot.setup.getCreativeTab()));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        playerEntity.func_184598_c(hand);
        if (!world.field_72995_K && playerEntity.func_225608_bj_()) {
            BlockRayTraceResult rayTraceResult = InternItem.func_219968_a((World)world, (PlayerEntity)playerEntity, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
            if (rayTraceResult != null && rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                return super.func_77659_a(world, playerEntity, hand);
            }
            ToolMode mode = InternItem.getToolModeFromStack(itemStack);
            mode = mode.getNext();
            InternItem.setToolModeInStack(itemStack, mode);
            if (mode.isBuildMode()) {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("info.woot.intern.mode.build", new Object[]{StringHelper.translate(mode.getTier().getTranslationKey())}), true);
            } else if (mode.isValidateMode()) {
                playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("info.woot.intern.mode.validate", new Object[]{StringHelper.translate(mode.getTier().getTranslationKey())}), true);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
    }

    private static void setToolModeInStack(ItemStack itemStack, ToolMode toolMode) {
        CompoundNBT compound = itemStack.func_77978_p();
        if (compound == null) {
            compound = new CompoundNBT();
        }
        compound.func_74778_a(NBT_MODE, toolMode.name());
        itemStack.func_77982_d(compound);
    }

    private static ToolMode getToolModeFromStack(ItemStack itemStack) {
        ToolMode mode = ToolMode.BUILD_1;
        CompoundNBT compound = itemStack.func_77978_p();
        if (compound == null) {
            InternItem.setToolModeInStack(itemStack, mode);
        } else {
            try {
                mode = ToolMode.valueOf(compound.func_74779_i(NBT_MODE));
            }
            catch (Exception e) {
                InternItem.setToolModeInStack(itemStack, mode);
            }
        }
        return mode;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        Block b;
        ActionResultType result = ActionResultType.PASS;
        ItemStack itemStack = context.func_195996_i();
        if (!context.func_195999_j().func_225608_bj_() && !context.func_195991_k().field_72995_K && (b = context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c()) instanceof HeartBlock) {
            BlockState blockState = context.func_195991_k().func_180495_p(context.func_195995_a());
            Direction facing = (Direction)blockState.func_177229_b((Property)BlockStateProperties.field_208157_J);
            ToolMode toolMode = InternItem.getToolModeFromStack(itemStack);
            if (toolMode.isBuildMode() && context.func_195999_j().func_175142_cm()) {
                FactoryHelper.BuildResult buildResult = FactoryHelper.tryBuild(context.func_195991_k(), context.func_195995_a(), context.func_195999_j(), facing, toolMode.getTier());
                if (buildResult == FactoryHelper.BuildResult.SUCCESS) {
                    context.func_195991_k().func_184148_a(null, context.func_195999_j().func_226277_ct_(), context.func_195999_j().func_226278_cu_(), context.func_195999_j().func_226281_cx_(), SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 0.5f * ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.8f));
                } else if (buildResult == FactoryHelper.BuildResult.ALL_BLOCKS_PLACED) {
                    FactoryHelper.tryValidate(context.func_195991_k(), context.func_195995_a(), context.func_195999_j(), facing, toolMode.getTier());
                } else {
                    context.func_195991_k().func_184148_a(null, context.func_195999_j().func_226277_ct_(), context.func_195999_j().func_226278_cu_(), context.func_195999_j().func_226281_cx_(), SoundEvents.field_187680_c, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                result = ActionResultType.SUCCESS;
            } else if (toolMode.isValidateMode()) {
                if (!context.func_195991_k().field_72995_K) {
                    FactoryHelper.tryValidate(context.func_195991_k(), context.func_195995_a(), context.func_195999_j(), facing, toolMode.getTier());
                }
                result = ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    void spawnParticle(World world, BlockPos pos, int amount) {
        BlockState blockState = world.func_180495_p(pos);
        Block b = world.func_180495_p(pos).func_177230_c();
        if (b.isAir(blockState, (IBlockReader)world, pos)) {
            for (int i = 0; i < amount; ++i) {
                double d0 = field_77697_d.nextGaussian() * 0.02;
                double d1 = field_77697_d.nextGaussian() * 0.02;
                double d2 = field_77697_d.nextGaussian() * 0.02;
                world.func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)((float)pos.func_177956_o() + field_77697_d.nextFloat()), (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), d0, d1, d2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(StringHelper.translate("info.woot.intern")));
        tooltip.add((ITextComponent)new StringTextComponent(StringHelper.translate("info.woot.intern.0")));
        tooltip.add((ITextComponent)new StringTextComponent(StringHelper.translate("info.woot.intern.1")));
        ToolMode toolMode = InternItem.getToolModeFromStack(stack);
        if (toolMode.isBuildMode()) {
            tooltip.add((ITextComponent)new StringTextComponent(StringHelper.translateFormat("info.woot.intern.mode.build", StringHelper.translate(toolMode.getTier().getTranslationKey()))));
            PatternRepository.Pattern pattern = PatternRepository.get().getPattern(toolMode.getTier());
            if (pattern != null) {
                for (FactoryComponent component : FactoryComponent.VALUES) {
                    int count = pattern.getFactoryBlockCount(component);
                    if (count <= 0) continue;
                    String key = "info.woot.intern.other.count";
                    TranslationTextComponent text = new TranslationTextComponent(component.getTranslationKey());
                    if (component == FactoryComponent.CELL) {
                        text = new TranslationTextComponent("info.woot.intern.cell");
                    } else if (toolMode == ToolMode.BUILD_1 && component == FactoryComponent.CONTROLLER) {
                        key = "info.woot.intern.controller.count.0";
                    } else if (component == FactoryComponent.CONTROLLER) {
                        key = "info.woot.intern.controller.count.1";
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent(key, new Object[]{count, text}));
                }
            }
        } else if (toolMode.isValidateMode()) {
            tooltip.add((ITextComponent)new StringTextComponent(StringHelper.translateFormat("info.woot.intern.mode.validate", StringHelper.translate(toolMode.getTier().getTranslationKey()))));
        }
    }

    public static enum ToolMode {
        BUILD_1(Tier.TIER_1),
        BUILD_2(Tier.TIER_2),
        BUILD_3(Tier.TIER_3),
        BUILD_4(Tier.TIER_4),
        BUILD_5(Tier.TIER_5),
        VALIDATE_1(Tier.TIER_1),
        VALIDATE_2(Tier.TIER_2),
        VALIDATE_3(Tier.TIER_3),
        VALIDATE_4(Tier.TIER_4),
        VALIDATE_5(Tier.TIER_5);

        public static ToolMode[] VALUES;
        private static EnumSet<ToolMode> BUILD_MODES;
        private static EnumSet<ToolMode> VALIDATE_TIERS;
        Tier tier;

        public ToolMode getNext() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public boolean isBuildMode() {
            return BUILD_MODES.contains((Object)this);
        }

        public boolean isValidateMode() {
            return VALIDATE_TIERS.contains((Object)this);
        }

        private ToolMode(Tier tier) {
            this.tier = tier;
        }

        public Tier getTier() {
            return this.tier;
        }

        static {
            VALUES = ToolMode.values();
            BUILD_MODES = EnumSet.range(BUILD_1, BUILD_5);
            VALIDATE_TIERS = EnumSet.range(VALIDATE_1, VALIDATE_5);
        }
    }
}

