/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.multiblock;

import ipsis.woot.modules.factory.blocks.HeartBlock;
import ipsis.woot.modules.factory.multiblock.MultiBlockGlueProvider;
import ipsis.woot.modules.factory.multiblock.MultiBlockMaster;
import java.util.ArrayList;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GlueHelper {
    private static boolean isGlueBlock(Block b) {
        return b instanceof MultiBlockGlueProvider;
    }

    private static boolean isMaster(Block b) {
        return b instanceof HeartBlock;
    }

    public static MultiBlockMaster findMasterNoTE(World world, BlockPos origin) {
        ArrayList<BlockPos> connected = new ArrayList<BlockPos>();
        Stack<BlockPos> traversing = new Stack<BlockPos>();
        MultiBlockMaster master = null;
        traversing.add(origin);
        while (master == null && !traversing.isEmpty()) {
            BlockPos currPos = (BlockPos)traversing.pop();
            connected.add(currPos);
            for (Direction facing : Direction.values()) {
                TileEntity te;
                BlockPos pos = currPos.func_177972_a(facing);
                if (!world.func_175667_e(pos)) continue;
                Block b = world.func_180495_p(pos).func_177230_c();
                if (GlueHelper.isGlueBlock(b) && !connected.contains(pos)) {
                    traversing.add(pos);
                    continue;
                }
                if (!GlueHelper.isMaster(b) || !((te = world.func_175625_s(pos)) instanceof MultiBlockMaster)) continue;
                master = (MultiBlockMaster)te;
            }
        }
        return master;
    }

    public static MultiBlockMaster findMaster(World world, MultiBlockGlueProvider iMultiBlockGlueProvider) {
        ArrayList<MultiBlockGlueProvider> connected = new ArrayList<MultiBlockGlueProvider>();
        Stack<MultiBlockGlueProvider> traversing = new Stack<MultiBlockGlueProvider>();
        MultiBlockMaster master = null;
        traversing.add(iMultiBlockGlueProvider);
        while (master == null && !traversing.isEmpty()) {
            MultiBlockGlueProvider curr = (MultiBlockGlueProvider)traversing.pop();
            connected.add(curr);
            for (Direction facing : Direction.values()) {
                BlockPos pos = curr.getGlue().getPos().func_177972_a(facing);
                if (!world.func_175667_e(pos)) continue;
                TileEntity te = world.func_175625_s(curr.getGlue().getPos().func_177972_a(facing));
                if (te instanceof MultiBlockGlueProvider && !connected.contains(te)) {
                    traversing.add((MultiBlockGlueProvider)te);
                    continue;
                }
                if (!(te instanceof MultiBlockMaster)) continue;
                master = (MultiBlockMaster)te;
            }
        }
        return master;
    }
}

