/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.items;

import ipsis.woot.Woot;
import ipsis.woot.advancements.Advancements;
import ipsis.woot.config.Config;
import ipsis.woot.config.ConfigOverride;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.policy.PolicyConfiguration;
import ipsis.woot.policy.PolicyRegistry;
import ipsis.woot.util.FakeMob;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class MobShardItem
extends Item {
    private static final String NBT_MOB = "Mob";
    private static final String NBT_KILLS = "Kills";

    public MobShardItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(Woot.setup.getCreativeTab()));
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.func_130014_f_().field_72995_K || !(attacker instanceof PlayerEntity)) {
            return false;
        }
        if (!(target instanceof MobEntity)) {
            return false;
        }
        if (MobShardItem.isProgrammed(stack)) {
            return false;
        }
        FakeMob fakeMob = new FakeMob((MobEntity)target);
        if (!fakeMob.isValid()) {
            return false;
        }
        if (!PolicyRegistry.get().canCaptureEntity(fakeMob.getResourceLocation()) || !MobShardItem.canShardCaptureMob(fakeMob.getResourceLocation())) {
            ((PlayerEntity)attacker).func_146105_b((ITextComponent)new TranslationTextComponent("chat.woot.mobshard.failure"), true);
            return false;
        }
        this.setProgrammedMob(stack, fakeMob);
        ((PlayerEntity)attacker).func_146105_b((ITextComponent)new TranslationTextComponent("chat.woot.mobshard.success"), true);
        return true;
    }

    private static boolean canShardCaptureMob(ResourceLocation resourceLocation) {
        for (String s : (List)PolicyConfiguration.SHARD_BLACKLIST_FULL_MOD.get()) {
            if (!s.equalsIgnoreCase(resourceLocation.func_110624_b())) continue;
            return false;
        }
        for (String s : (List)PolicyConfiguration.SHARD_BLACKLIST_ENTITY.get()) {
            if (!s.equalsIgnoreCase(resourceLocation.toString())) continue;
            return false;
        }
        return true;
    }

    public static boolean isProgrammed(ItemStack itemStack) {
        return MobShardItem.getProgrammedMob(itemStack).isValid();
    }

    public static FakeMob getProgrammedMob(ItemStack itemStack) {
        FakeMob fakeMob = new FakeMob();
        CompoundNBT compoundNBT = itemStack.func_196082_o();
        if (itemStack.func_77978_p().func_74764_b(NBT_MOB)) {
            fakeMob = new FakeMob(itemStack.func_77978_p().func_74775_l(NBT_MOB));
        }
        return fakeMob;
    }

    private void setProgrammedMob(ItemStack itemStack, FakeMob fakeMob) {
        CompoundNBT compoundNBT = itemStack.func_196082_o();
        CompoundNBT mobNbt = new CompoundNBT();
        FakeMob.writeToNBT(fakeMob, mobNbt);
        compoundNBT.func_218657_a(NBT_MOB, (INBT)mobNbt);
        compoundNBT.func_74768_a(NBT_KILLS, 0);
    }

    private static boolean isMatchingMob(ItemStack itemStack, FakeMob fakeMob) {
        if (itemStack.func_77973_b() != FactorySetup.MOB_SHARD_ITEM.get()) {
            return false;
        }
        if (!MobShardItem.isProgrammed(itemStack)) {
            return false;
        }
        FakeMob programmedMob = MobShardItem.getProgrammedMob(itemStack);
        if (!programmedMob.isValid()) {
            return false;
        }
        return programmedMob.equals(fakeMob);
    }

    public static void handleKill(PlayerEntity playerEntity, FakeMob fakeMob) {
        ItemStack foundStack = ItemStack.field_190927_a;
        for (int i = 0; i <= 9; ++i) {
            ItemStack itemStack = playerEntity.field_71071_by.func_70301_a(i);
            if (itemStack.func_190926_b() || !MobShardItem.isMatchingMob(itemStack, fakeMob)) continue;
            foundStack = itemStack;
            break;
        }
        if (!foundStack.func_190926_b()) {
            MobShardItem.incrementKills(foundStack, 1);
            if (MobShardItem.isFullyProgrammed(foundStack) && playerEntity instanceof ServerPlayerEntity) {
                Advancements.MOB_CAPTURE_TRIGGER.trigger((ServerPlayerEntity)playerEntity, fakeMob);
            }
        }
    }

    private static void incrementKills(ItemStack itemStack, int v) {
        if (itemStack.func_77973_b() != FactorySetup.MOB_SHARD_ITEM.get()) {
            return;
        }
        FakeMob fakeMob = MobShardItem.getProgrammedMob(itemStack);
        if (!fakeMob.isValid()) {
            return;
        }
        if (!PolicyRegistry.get().canCaptureEntity(fakeMob.getResourceLocation()) || !MobShardItem.canShardCaptureMob(fakeMob.getResourceLocation())) {
            return;
        }
        int killCount = itemStack.func_77978_p().func_74762_e(NBT_KILLS);
        if (!MobShardItem.isFull(itemStack)) {
            itemStack.func_77978_p().func_74768_a(NBT_KILLS, killCount += v);
        }
    }

    private static boolean isFull(ItemStack itemStack) {
        int killCount = itemStack.func_77978_p().func_74762_e(NBT_KILLS);
        FakeMob fakeMob = MobShardItem.getProgrammedMob(itemStack);
        if (!fakeMob.isValid()) {
            return false;
        }
        return killCount >= Config.OVERRIDE.getIntegerOrDefault(fakeMob, ConfigOverride.OverrideKey.SHARD_KILLS);
    }

    public static boolean isFullyProgrammed(ItemStack itemStack) {
        return MobShardItem.isProgrammed(itemStack) && MobShardItem.isFull(itemStack);
    }

    public static void setJEIEnderShard(ItemStack itemStack) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("nbt_jei_shard", 1);
        itemStack.func_77982_d(nbt);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return MobShardItem.isFullyProgrammed(itemStack) || itemStack.func_77978_p().func_74764_b("nbt_jei_shard");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.mobshard.0"));
        tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.mobshard.1"));
        tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.mobshard.2"));
        tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.mobshard.3"));
        FakeMob fakeMob = MobShardItem.getProgrammedMob(stack);
        if (!fakeMob.isValid()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.mobshard.a.0"));
            return;
        }
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(fakeMob.getResourceLocation());
        if (entityType != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent(entityType.func_210760_d()));
        }
        if (fakeMob.hasTag()) {
            tooltip.add((ITextComponent)new StringTextComponent("[" + fakeMob.getTag() + "]"));
        }
        int killCount = stack.func_77978_p().func_74762_e(NBT_KILLS);
        if (MobShardItem.isFull(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.mobshard.a.1"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.mobshard.b.0", new Object[]{killCount, Config.OVERRIDE.getIntegerOrDefault(fakeMob, ConfigOverride.OverrideKey.SHARD_KILLS)}));
        }
    }
}

