/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.Woot;
import ipsis.woot.advancements.Advancements;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.blocks.UpgradeBlock;
import ipsis.woot.modules.factory.items.PerkItem;
import ipsis.woot.modules.factory.multiblock.MultiBlockTileEntity;
import ipsis.woot.modules.factory.multiblock.MultiBlockTracker;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.util.WootDebug;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class UpgradeTileEntity
extends MultiBlockTileEntity
implements WootDebug {
    public UpgradeTileEntity() {
        super((TileEntityType)FactorySetup.FACTORY_UPGRADE_BLOCK_TILE.get());
    }

    public boolean tryAddUpgrade(World world, PlayerEntity playerEntity, BlockState state, Perk type) {
        if (state.func_177229_b(UpgradeBlock.UPGRADE) == Perk.EMPTY) {
            if (Perk.LEVEL_1_PERKS.contains((Object)type)) {
                world.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a(UpgradeBlock.UPGRADE, (Comparable)((Object)type)), 2);
                this.glue.onGoodbye();
                MultiBlockTracker.get().addEntry(world, this.field_174879_c);
                Woot.setup.getLogger().debug("tryAddUpgrade: added {}", (Object)type);
                if (playerEntity instanceof ServerPlayerEntity) {
                    Advancements.APPLY_PERK_TRIGGER.trigger((ServerPlayerEntity)playerEntity, type);
                }
                return true;
            }
            playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("chat.woot.perk.fail.0"), false);
            return false;
        }
        Perk upgrade = (Perk)((Object)this.func_195044_w().func_177229_b(UpgradeBlock.UPGRADE));
        Perk.Group currType = Perk.getGroup(upgrade);
        Perk.Group addType = Perk.getGroup(type);
        int currLevel = Perk.getLevel(upgrade);
        int addLevel = Perk.getLevel(type);
        if (currType != addType) {
            playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("chat.woot.perk.fail.1"), false);
            return false;
        }
        if (currLevel == 3) {
            playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("chat.woot.perk.fail.2"), false);
            return false;
        }
        if (currLevel == addLevel) {
            playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("chat.woot.perk.fail.4"), false);
            return false;
        }
        if (currLevel + 1 != addLevel) {
            playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("chat.woot.perk.fail.4", new Object[]{currLevel + 1}), false);
            return false;
        }
        world.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a(UpgradeBlock.UPGRADE, (Comparable)((Object)type)), 2);
        this.glue.onGoodbye();
        MultiBlockTracker.get().addEntry(world, this.field_174879_c);
        Woot.setup.getLogger().debug("tryAddUpgrade: added {}", (Object)type);
        return true;
    }

    public void dropItems(BlockState state, World world, BlockPos pos) {
        Perk upgrade = (Perk)((Object)state.func_177229_b(UpgradeBlock.UPGRADE));
        if (upgrade == Perk.EMPTY) {
            return;
        }
        int currLevel = Perk.getLevel(upgrade);
        for (int i = 1; i <= 3; ++i) {
            Perk.Group type;
            ItemStack itemStack;
            if (i > currLevel || (itemStack = PerkItem.getItemStack(type = Perk.getGroup(upgrade), i)).func_190926_b()) continue;
            itemStack.func_190920_e(1);
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack);
        }
    }

    @Nullable
    public Perk getUpgrade(BlockState state) {
        return (Perk)((Object)state.func_177229_b(UpgradeBlock.UPGRADE));
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> UpgradeTileEntity");
        debug.add("      hasMaster: " + this.glue.hasMaster());
        debug.add("      upgrade: " + this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(UpgradeBlock.UPGRADE));
        return debug;
    }
}

