/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.anvil.blocks;

import ipsis.woot.crafting.AnvilRecipe;
import ipsis.woot.modules.anvil.AnvilConfiguration;
import ipsis.woot.modules.anvil.AnvilSetup;
import ipsis.woot.modules.anvil.blocks.AnvilTileEntity;
import ipsis.woot.modules.debug.items.DebugItem;
import ipsis.woot.util.WootDebug;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AnvilBlock
extends Block
implements WootDebug {
    private static final VoxelShape PART_BASE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape PART_LOWER_X = Block.func_208617_a((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0);
    private static final VoxelShape PART_MID_X = Block.func_208617_a((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape PART_UPPER_X = Block.func_208617_a((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape PART_LOWER_Z = Block.func_208617_a((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)13.0);
    private static final VoxelShape PART_MID_Z = Block.func_208617_a((double)6.0, (double)5.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape PART_UPPER_Z = Block.func_208617_a((double)3.0, (double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape X_AXIS_AABB = VoxelShapes.func_216384_a((VoxelShape)PART_BASE, (VoxelShape[])new VoxelShape[]{PART_LOWER_X, PART_MID_X, PART_UPPER_X});
    private static final VoxelShape Z_AXIS_AABB = VoxelShapes.func_216384_a((VoxelShape)PART_BASE, (VoxelShape[])new VoxelShape[]{PART_LOWER_Z, PART_MID_Z, PART_UPPER_Z});

    public AnvilBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(3.5f));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AnvilTileEntity();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176746_e());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        return direction.func_176740_k() == Direction.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        TileEntity te;
        if (world.field_72995_K) {
            super.func_225533_a_(blockState, world, pos, playerEntity, hand, blockRayTraceResult);
        }
        if ((te = world.func_175625_s(pos)) instanceof AnvilTileEntity) {
            AnvilTileEntity anvil = (AnvilTileEntity)te;
            ItemStack heldItem = playerEntity.func_184586_b(hand);
            if (playerEntity.func_225608_bj_() && heldItem.func_190926_b()) {
                anvil.dropItem(playerEntity);
            } else if (heldItem.func_77973_b() == AnvilSetup.HAMMER_ITEM.get()) {
                anvil.tryCraft(playerEntity);
            } else if (!anvil.hasBaseItem()) {
                if (AnvilRecipe.isValidInput(heldItem)) {
                    ItemStack baseItem = heldItem.func_77946_l();
                    baseItem.func_190920_e(1);
                    anvil.setBaseItem(baseItem);
                    heldItem.func_190918_g(1);
                    if (heldItem.func_190926_b()) {
                        playerEntity.field_71071_by.func_70299_a(playerEntity.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    } else {
                        playerEntity.field_71071_by.func_70299_a(playerEntity.field_71071_by.field_70461_c, heldItem);
                    }
                    playerEntity.field_71070_bA.func_75142_b();
                } else {
                    playerEntity.func_146105_b((ITextComponent)new TranslationTextComponent("chat.woot.anvil.nobase"), true);
                }
            } else {
                ItemStack ingredient = heldItem.func_77946_l();
                ingredient.func_190920_e(1);
                if (anvil.addIngredient(ingredient)) {
                    heldItem.func_190918_g(1);
                    if (heldItem.func_190926_b()) {
                        playerEntity.field_71071_by.func_70299_a(playerEntity.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    } else {
                        playerEntity.field_71071_by.func_70299_a(playerEntity.field_71071_by.field_70461_c, heldItem);
                    }
                    playerEntity.field_71070_bA.func_75142_b();
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean isAnvilHot(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196814_hQ;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (((Boolean)AnvilConfiguration.ANVIL_PARTICILES.get()).booleanValue() && rand.nextInt(10) == 0 && this.isAnvilHot(worldIn, pos)) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public void func_196243_a(BlockState blockState, World world, BlockPos pos, BlockState newBlockState, boolean isMoving) {
        if (blockState.func_177230_c() != newBlockState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof AnvilTileEntity) {
                ((AnvilTileEntity)te).dropContents(world, pos);
            }
            super.func_196243_a(blockState, world, pos, newBlockState, isMoving);
        }
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> AnvilBlock");
        DebugItem.getTileEntityDebug(debug, itemUseContext);
        return debug;
    }
}

