/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ipsis.woot.Woot;
import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.util.helper.RandomHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class ExoticDropsLootModifier
extends LootModifier {
    private int rolls;
    private double dropChance;
    private List<DropWeighted> drops = new ArrayList<DropWeighted>();

    public ExoticDropsLootModifier(ILootCondition[] conditions, int rolls, double chance, int[] weights) {
        super(conditions);
        this.rolls = rolls;
        this.dropChance = (Double)FactoryConfiguration.EXOTIC.get();
        this.drops.add(new DropWeighted(Exotic.EXOTIC_A.getItemStack(), weights[0]));
        this.drops.add(new DropWeighted(Exotic.EXOTIC_B.getItemStack(), weights[1]));
        this.drops.add(new DropWeighted(Exotic.EXOTIC_C.getItemStack(), weights[2]));
        this.drops.add(new DropWeighted(Exotic.EXOTIC_D.getItemStack(), weights[3]));
        this.drops.add(new DropWeighted(Exotic.EXOTIC_E.getItemStack(), weights[4]));
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        for (int roll = 0; roll < this.rolls; ++roll) {
            if (!RandomHelper.rollPercentage(this.dropChance, "exoticDrops")) continue;
            ItemStack drop = this.getWeightedDrop();
            if (!drop.func_190926_b()) {
                generatedLoot.add(drop.func_77946_l());
                continue;
            }
            Woot.setup.getLogger().error("Rolled exotic dropping as empty stack");
        }
        return generatedLoot;
    }

    private ItemStack getWeightedDrop() {
        if (WeightedRandom.func_76272_a(this.drops) > 0) {
            return ((DropWeighted)WeightedRandom.func_76271_a((Random)RandomHelper.RANDOM, this.drops)).itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ExoticDropsLootModifier> {
        public ExoticDropsLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            int rolls = JSONUtils.func_151203_m((JsonObject)object, (String)"rolls");
            double chance = JSONUtils.func_151217_k((JsonObject)object, (String)"dropChance");
            int[] weights = new int[Exotic.getExoticCount()];
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = 1;
            }
            JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)object, (String)"weights");
            if (jsonArray.isJsonArray() && jsonArray.size() == Exotic.getExoticCount()) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonElement element = jsonArray.get(i);
                    try {
                        weights[i] = element.getAsInt();
                        continue;
                    }
                    catch (Exception e) {
                        Woot.setup.getLogger().error("ExoticDrops: weights not all integers {}", (Object)element);
                        weights[i] = 1;
                    }
                }
            }
            Woot.setup.getLogger().info("ExoticDrops rolls:{} chance:{} weights:{}", (Object)rolls, (Object)chance, (Object)weights);
            return new ExoticDropsLootModifier(conditions, rolls, chance, weights);
        }

        public JsonObject write(ExoticDropsLootModifier instance) {
            ILootCondition[] conditions = new ILootCondition[]{};
            return this.makeConditions(conditions);
        }
    }

    private class DropWeighted
    extends WeightedRandom.Item {
        public ItemStack itemStack;

        public DropWeighted(ItemStack itemStack, int weight) {
            super(weight);
            this.itemStack = itemStack;
        }
    }
}

