/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ipsis.woot.util.FluidStackHelper;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ObjectHolder;

public class FluidConvertorRecipeBuilder {
    private final Ingredient catalyst;
    private final int catalystCount;
    private final FluidStack inFluid;
    private final FluidStack result;
    private final int energy;
    @ObjectHolder(value="woot:fluidconvertor")
    public static final IRecipeSerializer<IRecipe<?>> SERIALIZER = null;

    public FluidConvertorRecipeBuilder(FluidStack result, int energy, Ingredient catalyst, int catalystCount, FluidStack inFluid) {
        this.result = result;
        this.catalyst = catalyst;
        this.catalystCount = catalystCount;
        this.energy = energy;
        this.inFluid = inFluid;
    }

    public static FluidConvertorRecipeBuilder fluidConvertorRecipe(FluidStack result, int energy, Ingredient catalyst, int catalystCount, FluidStack inFluid) {
        return new FluidConvertorRecipeBuilder(result, energy, catalyst, catalystCount, inFluid);
    }

    public void build(Consumer<IFinishedRecipe> recipe, String name) {
        recipe.accept(new Result(new ResourceLocation("woot", "fluidconvertor/" + name), this.result, this.energy, this.catalyst, this.catalystCount, this.inFluid));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient catalyst;
        private final int catalystcount;
        private final FluidStack inputFluid;
        private final FluidStack result;
        private final int energy;

        public Result(ResourceLocation id, FluidStack result, int energy, Ingredient catalyst, int catalystCount, FluidStack inputFluid) {
            this.id = id;
            this.catalyst = catalyst;
            this.catalystcount = catalystCount;
            this.inputFluid = inputFluid;
            this.result = result;
            this.energy = energy;
        }

        public void func_218610_a(JsonObject json) {
            json.add("catalyst", this.catalyst.func_200304_c());
            json.addProperty("catalyst_count", (Number)this.catalystcount);
            json.add("input", (JsonElement)FluidStackHelper.create(this.inputFluid));
            json.add("result", (JsonElement)FluidStackHelper.create(this.result));
            json.addProperty("energy", (Number)this.energy);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

