/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.compat.bloodmagic;

import ipsis.woot.modules.factory.FormedSetup;
import ipsis.woot.modules.factory.blocks.HeartTileEntity;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.util.FakeMob;
import java.util.function.Consumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.tile.TileAltar;

@RitualRegister(value="ritualinfernalmachine")
public class RitualInfernalMachine
extends Ritual {
    public static final String ALTAR_RANGE = "altar";
    public static final String HEART_RANGE = "heart";
    public static final String NAME = "ritualInfernalMachine";
    public static final int SACRIFICE_AMOUNT = 25;
    private BlockPos altarOffsetPos = new BlockPos(0, 0, 0);
    private BlockPos heartOffsetPos = new BlockPos(0, 0, 0);

    public RitualInfernalMachine() {
        super(NAME, 0, 40000, "ritual.woot.ritualInfernalMachine");
        this.addBlockRange(ALTAR_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(HEART_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 21));
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
        this.setMaximumVolumeAndDistanceOfRange(HEART_RANGE, 0, 15, 15);
    }

    public void performRitual(IMasterRitualStone iMasterRitualStone) {
        World world = iMasterRitualStone.getWorldObj();
        int currEssence = iMasterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currEssence < this.getRefreshCost()) {
            iMasterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos ritualPos = iMasterRitualStone.getMasterBlockPos();
        int maxEffects = currEssence / this.getRefreshCost();
        int totalEffects = 0;
        BlockPos altarPos = ritualPos.func_177971_a((Vector3i)this.altarOffsetPos);
        TileEntity altarTile = world.func_175625_s(altarPos);
        AreaDescriptor altarRange = iMasterRitualStone.getBlockRange(ALTAR_RANGE);
        if (!altarRange.isWithinArea(this.altarOffsetPos) || !(altarTile instanceof TileAltar)) {
            for (BlockPos pos : altarRange.getContainedPositions(ritualPos)) {
                TileEntity tile = world.func_175625_s(pos);
                if (!(tile instanceof TileAltar)) continue;
                altarTile = tile;
                this.altarOffsetPos = pos.func_177973_b((Vector3i)ritualPos);
                altarRange.resetCache();
                break;
            }
        }
        if (altarTile instanceof TileAltar) {
            BlockPos heartPos = ritualPos.func_177971_a((Vector3i)this.heartOffsetPos);
            TileEntity heartTile = world.func_175625_s(heartPos);
            AreaDescriptor heartRange = iMasterRitualStone.getBlockRange(HEART_RANGE);
            if (!heartRange.isWithinArea(this.heartOffsetPos) || !(heartTile instanceof HeartTileEntity)) {
                for (BlockPos pos : heartRange.getContainedPositions(ritualPos)) {
                    TileEntity tile = world.func_175625_s(pos);
                    if (!(tile instanceof HeartTileEntity) || !((HeartTileEntity)tile).isFormed()) continue;
                    heartTile = tile;
                    this.heartOffsetPos = pos.func_177973_b((Vector3i)ritualPos);
                    heartRange.resetCache();
                    break;
                }
            }
            if (heartTile instanceof HeartTileEntity) {
                HeartTileEntity heart = (HeartTileEntity)heartTile;
                TileAltar altar = (TileAltar)altarTile;
                FormedSetup formedSetup = heart.getFormedSetup();
                if (formedSetup != null && heart.couldFinish() && heart.hasFlayedPerk()) {
                    for (FakeMob fakeMob : heart.getFormedMobs()) {
                        int ratio;
                        int count = formedSetup.getAllMobParams().get(fakeMob).getMobCount(formedSetup.getAllPerks().containsKey((Object)Perk.Group.MASS), formedSetup.hasMassExotic());
                        if (count == 0 || BloodMagicAPI.INSTANCE.getBlacklist().getSacrifice().contains(fakeMob.getResourceLocation()) || (ratio = BloodMagicAPI.INSTANCE.getValueManager().getSacrificial().getOrDefault(fakeMob.getResourceLocation(), 25).intValue()) <= 0) continue;
                        for (int i = 0; i < count; ++i) {
                            altar.sacrificialDaggerCall(ratio, true);
                        }
                        if (++totalEffects < maxEffects) continue;
                        break;
                    }
                }
            }
        }
        iMasterRitualStone.getOwnerNetwork().syphon(iMasterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    public int getRefreshCost() {
        return 2;
    }

    public void gatherComponents(Consumer<RitualComponent> consumer) {
        this.addCornerRunes(consumer, 4, -1, EnumRuneType.EARTH);
        this.addCornerRunes(consumer, 3, 0, EnumRuneType.FIRE);
        this.addCornerRunes(consumer, 2, 1, EnumRuneType.AIR);
        this.addCornerRunes(consumer, 1, 2, EnumRuneType.WATER);
        this.addParallelRunes(consumer, 1, 1, EnumRuneType.DUSK);
        this.addCornerRunes(consumer, 1, 0, EnumRuneType.DUSK);
    }

    public Ritual getNewCopy() {
        return new RitualInfernalMachine();
    }
}

