/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import ipsis.woot.config.Config;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMob;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class MobCommand {
    private static final String TAG = "commands.woot.mob.";
    static final SuggestionProvider<CommandSource> ENTITY_SUGGESTIONS = (ctx, builder) -> ISuggestionProvider.func_212476_a(ForgeRegistries.ENTITIES.getKeys().stream(), (SuggestionsBuilder)builder);

    static ArgumentBuilder<CommandSource, ?> register() {
        return Commands.func_197057_a((String)"mob").then(InfoCommand.register());
    }

    private static int mobInfo(CommandSource source, ResourceLocation resourceLocation, String tag) throws CommandSyntaxException {
        FakeMob fakeMob = tag.equalsIgnoreCase("") ? new FakeMob(resourceLocation.toString()) : new FakeMob(resourceLocation.toString() + "," + tag);
        if (fakeMob.isValid() && SpawnController.get().isLivingEntity(fakeMob, (World)source.func_197023_e())) {
            int health = SpawnController.get().getMobHealth(fakeMob, (World)source.func_197023_e());
            int xp = SpawnController.get().getMobExperience(fakeMob, (World)source.func_197023_e());
            Tier mobTier = Config.OVERRIDE.getMobTier(fakeMob, (World)source.func_197023_e());
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.woot.mob.info.summary", new Object[]{fakeMob, health, xp, mobTier}), true);
        }
        return 0;
    }

    private static class InfoCommand {
        private InfoCommand() {
        }

        static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"info").requires(cs -> cs.func_197034_c(0))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entity", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(ENTITY_SUGGESTIONS).executes(ctx -> MobCommand.mobInfo((CommandSource)ctx.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"entity"), ""))).then(Commands.func_197056_a((String)"tag", (ArgumentType)StringArgumentType.string()).executes(ctx -> MobCommand.mobInfo((CommandSource)ctx.getSource(), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"entity"), StringArgumentType.getString((CommandContext)ctx, (String)"tag")))));
        }
    }
}

