/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.recipe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraftforge.fluids.FluidStack;

public class FluidTagIngredient {
    private final FluidStack fluid;
    private final String tag;
    private final int amount;

    public FluidTagIngredient(FluidStack fs, String str, int cnt) {
        this.fluid = fs == null ? FluidStack.EMPTY : fs;
        this.tag = str == null ? "" : str;
        this.amount = cnt;
    }

    public FluidStack getFluidStack() {
        return this.fluid;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasFluid() {
        return !this.fluid.isEmpty();
    }

    public boolean hasTag() {
        return !this.tag.isEmpty();
    }

    public List<Fluid> list() {
        if (!this.hasTag()) {
            return null;
        }
        for (ITag.INamedTag fluidTag : FluidTags.func_241280_c_()) {
            if (!fluidTag.func_230234_a_().toString().equalsIgnoreCase(this.tag)) continue;
            return fluidTag.func_230236_b_();
        }
        return null;
    }

    public List<FluidStack> getMatchingFluids() {
        List<Fluid> fluids = this.list();
        if (fluids == null) {
            return null;
        }
        ArrayList<FluidStack> me = new ArrayList<FluidStack>();
        for (Fluid f : fluids) {
            me.add(new FluidStack(f, this.amount));
        }
        return me;
    }

    public static FluidTagIngredient readFromPacket(PacketBuffer buffer) {
        return new FluidTagIngredient(FluidStack.readFromPacket((PacketBuffer)buffer), buffer.func_218666_n(), buffer.readInt());
    }

    public void writeToPacket(PacketBuffer buffer) {
        this.fluid.writeToPacket(buffer);
        buffer.func_180714_a(this.tag);
        buffer.writeInt(this.amount);
    }

    public int getAmount() {
        return this.amount;
    }
}

