/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.base.PacketBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketFluidSync
extends PacketBase {
    private BlockPos pos;
    private FluidStack fluid;

    public PacketFluidSync(BlockPos p, FluidStack fluid) {
        this.pos = p;
        this.fluid = fluid;
    }

    public static void handle(PacketFluidSync message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketFluidSync.doWork(message));
        message.done(ctx);
    }

    private static void doWork(PacketFluidSync message) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
        if (te instanceof TileEntityBase) {
            ((TileEntityBase)te).setFluid(message.fluid);
        }
    }

    public static PacketFluidSync decode(PacketBuffer buf) {
        PacketFluidSync msg = new PacketFluidSync(buf.func_179259_c(), FluidStack.loadFluidStackFromNBT((CompoundNBT)buf.func_150793_b()));
        return msg;
    }

    public static void encode(PacketFluidSync msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        CompoundNBT tags = new CompoundNBT();
        if (msg.fluid != null) {
            msg.fluid.writeToNBT(tags);
        }
        buf.func_150786_a(tags);
    }
}

