/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.builder;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.item.builder.BuildStyle;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.PacketSwapBlock;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BuilderItem
extends ItemBase {
    public BuildStyle style;

    public BuilderItem(Item.Properties properties, BuildStyle t) {
        super(properties.func_200917_a(1).func_200918_c(4096));
        this.style = t;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String msg = TextFormatting.GREEN + UtilChat.lang(BuilderActionType.getName(stack));
        tooltip.add((ITextComponent)new TranslationTextComponent(msg));
        BlockState target = BuilderActionType.getBlockState(stack);
        String block = "scepter.cyclic.nothing";
        if (target != null) {
            block = target.func_177230_c().func_149739_a();
        }
        tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.AQUA + UtilChat.lang(block)));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        BuilderActionType.tickTimeout(stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        BuildStyle buildStyle = ((BuilderItem)stack.func_77973_b()).style;
        if (side != null && buildStyle.isOffset()) {
            pos = pos.func_177972_a(side);
        }
        if (context.func_195991_k().field_72995_K) {
            BuilderActionType type = BuilderItem.getActionType(stack);
            PacketSwapBlock message = new PacketSwapBlock(pos, type, side, context.func_221531_n());
            PacketRegistry.INSTANCE.sendToServer((Object)message);
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public static BuilderActionType getActionType(ItemStack stack) {
        BuilderActionType type = BuilderActionType.values()[BuilderActionType.get(stack)];
        return type;
    }

    public static ItemStack getIfHeld(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof BuilderItem) {
            return heldItem;
        }
        heldItem = player.func_184592_cb();
        if (heldItem.func_77973_b() instanceof BuilderItem) {
            return heldItem;
        }
        return ItemStack.field_190927_a;
    }
}

