/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilNBT;
import com.lothrazar.cyclic.util.UtilShape;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;

public class OreProspector
extends ItemBase {
    private static final String ORESIZE = "oresize";
    private static final String NBT_DIM = "dim";
    public static ForgeConfigSpec.IntValue RANGE;

    public OreProspector(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (player.func_213453_ef()) {
            UtilItemStack.deleteTag(itemstack);
            player.func_184609_a(handIn);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        ItemStack held = player.func_184586_b(hand);
        if (player.func_184811_cZ().func_185141_a(held.func_77973_b())) {
            return ActionResultType.PASS;
        }
        player.func_184811_cZ().func_185145_a(held.func_77973_b(), 10);
        held.func_77982_d(null);
        BlockPos pos = context.func_195995_a();
        List<BlockPos> shape = UtilShape.cubeSquareBase(pos.func_177977_b(), (Integer)RANGE.get(), 2);
        ArrayList<BlockPos> ores = new ArrayList<BlockPos>();
        World world = context.func_195991_k();
        for (BlockPos p : shape) {
            if (!world.func_180495_p(p).func_235714_a_((ITag)Tags.Blocks.ORES)) continue;
            ores.add(p);
        }
        held.func_196082_o().func_74778_a(NBT_DIM, UtilWorld.dimensionToString(player.field_70170_p));
        int i = 0;
        for (BlockPos p : ores) {
            CompoundNBT tag = new CompoundNBT();
            UtilNBT.putBlockPos(tag, p);
            held.func_77978_p().func_218657_a("tag" + i, (INBT)tag);
            ++i;
        }
        held.func_77978_p().func_74768_a(ORESIZE, i);
        player.func_184609_a(hand);
        UtilItemStack.damageItem((LivingEntity)player, held);
        return ActionResultType.SUCCESS;
    }

    public static ItemStack getIfHeld(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof OreProspector) {
            return heldItem;
        }
        heldItem = player.func_184592_cb();
        if (heldItem.func_77973_b() instanceof OreProspector) {
            return heldItem;
        }
        return ItemStack.field_190927_a;
    }

    public static ArrayList<BlockPosDim> getPosition(ItemStack item) {
        ArrayList<BlockPosDim> list = new ArrayList<BlockPosDim>();
        if (!item.func_77942_o() || !item.func_77978_p().func_74764_b(ORESIZE)) {
            return list;
        }
        int size = item.func_77978_p().func_74762_e(ORESIZE);
        String dim = item.func_77978_p().func_74779_i(NBT_DIM);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = UtilNBT.getBlockPos(item.func_77978_p().func_74775_l("tag" + i));
            list.add(new BlockPosDim(pos, dim, item.func_77978_p()));
        }
        return list;
    }
}

