/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.base.EnchantBase;
import com.lothrazar.cyclic.net.PacketPlayerFalldamage;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilNBT;
import com.lothrazar.cyclic.util.UtilParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantLaunch
extends EnchantBase {
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "launch";
    private static final float LAUNCH_POWER = 1.05f;
    private static final int ROTATIONPITCH = 70;
    private static final int COOLDOWN = 60;
    private static final String NBT_USES = "launchuses";

    public EnchantLaunch(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int func_77325_b() {
        return 10;
    }

    public boolean func_92089_a(ItemStack stack) {
        boolean yes = stack.func_77973_b() instanceof ElytraItem || stack.func_77973_b() instanceof ArmorItem && ((ArmorItem)stack.func_77973_b()).func_185083_B_() == EquipmentSlotType.FEET;
        return yes;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.func_92089_a(stack);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity p = (PlayerEntity)event.getEntity();
            ItemStack armorStack = this.getFirstArmorStackWithEnchant((LivingEntity)p);
            if (armorStack.func_190926_b()) {
                return;
            }
            if ((!p.field_70160_al || p.func_233570_aj_()) && armorStack.func_196082_o().func_74762_e(NBT_USES) > 0) {
                UtilNBT.setItemStackNBTVal(armorStack, NBT_USES, 0);
            }
        }
    }

    public void onKeyInput(PlayerEntity player) {
        if (player == null || player.func_184187_bx() instanceof BoatEntity) {
            return;
        }
        ItemStack feet = this.getFirstArmorStackWithEnchant((LivingEntity)player);
        if (feet.func_190926_b() || player.func_213453_ef()) {
            return;
        }
        if (!EnchantmentHelper.func_82781_a((ItemStack)feet).containsKey((Object)this)) {
            return;
        }
        if (player.func_184811_cZ().func_185141_a(feet.func_77973_b())) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && player.func_226278_cu_() < player.field_70137_T && player.field_70160_al && !player.func_70090_H()) {
            int level = (Integer)EnchantmentHelper.func_82781_a((ItemStack)feet).get((Object)this);
            int uses = feet.func_196082_o().func_74762_e(NBT_USES);
            player.field_70143_R = 0.0f;
            float angle = player.func_213322_ci().field_72450_a == 0.0 && player.func_213322_ci().field_72449_c == 0.0 ? 90.0f : 70.0f;
            UtilEntity.launch((Entity)player, angle, 1.05f);
            UtilParticle.spawnParticle(player.func_130014_f_(), (IParticleData)ParticleTypes.field_197614_g, player.func_233580_cy_(), 7);
            if (++uses >= level) {
                if (!feet.func_190926_b()) {
                    UtilEntity.setCooldownItem(player, feet.func_77973_b(), 60);
                }
                uses = 0;
            }
            UtilNBT.setItemStackNBTVal(feet, NBT_USES, uses);
            player.field_70143_R = 0.0f;
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketPlayerFalldamage());
        }
    }
}

