/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.melter;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.melter.ContainerMelter;
import com.lothrazar.cyclic.block.melter.RecipeMelter;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileMelter
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    static final int MAX = 64000;
    public static final int CAPACITY = 64000;
    public static final int TRANSFER_FLUID_PER_TICK = 50;
    public static final int TIMER_FULL = 60;
    public static ForgeConfigSpec.IntValue POWERCONF;
    public FluidTankBase tank;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    ItemStackHandler inventory = new ItemStackHandler(2);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private RecipeMelter currentRecipe;

    public TileMelter() {
        super(TileRegistry.melter);
        this.tank = new FluidTankBase(this, 64000, this.isFluidValid());
    }

    public void func_73660_a() {
        this.syncEnergy();
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            this.timer = 0;
            return;
        }
        if (this.currentRecipe == null || !this.currentRecipe.matches(this, this.field_145850_b)) {
            this.findMatchingRecipe();
            if (this.currentRecipe == null) {
                this.timer = 0;
                return;
            }
        }
        if (--this.timer < 0) {
            this.timer = 0;
        }
        if (this.timer == 0 && this.tryProcessRecipe()) {
            this.timer = 60;
            this.energy.extractEnergy(cost, false);
        }
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerMelter(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public float getCapacity() {
        return 64000.0f;
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public ItemStack getStackInputSlot(int slot) {
        IItemHandler inv = (IItemHandler)this.inventoryCap.orElse(null);
        return inv == null ? ItemStack.field_190927_a : inv.getStackInSlot(slot);
    }

    private void findMatchingRecipe() {
        if (this.currentRecipe != null && this.currentRecipe.matches(this, this.field_145850_b)) {
            return;
        }
        this.currentRecipe = null;
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(CyclicRecipeType.MELTER);
        for (RecipeMelter rec : recipes) {
            if (!rec.matches(this, this.field_145850_b) || this.tank.getFluid() != null && !this.tank.getFluid().isEmpty() && rec.getRecipeFluid().getFluid() != this.tank.getFluid().getFluid()) continue;
            this.currentRecipe = rec;
            this.timer = 60;
            return;
        }
    }

    private boolean tryProcessRecipe() {
        int test = this.tank.fill(this.currentRecipe.getRecipeFluid(), IFluidHandler.FluidAction.SIMULATE);
        if (test == this.currentRecipe.getRecipeFluid().getAmount() && this.currentRecipe.matches(this, this.field_145850_b)) {
            this.inventory.getStackInSlot(0).func_190918_g(1);
            this.inventory.getStackInSlot(1).func_190918_g(1);
            this.tank.fill(this.currentRecipe.getRecipeFluid(), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    static enum Fields {
        REDSTONE,
        TIMER,
        RENDER;

    }
}

