/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.disenchant;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.disenchant.ContainerDisenchant;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.capability.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.fluid.FluidXpJuiceHolder;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileDisenchant
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    static final int MAX = 640000;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_BOOK = 1;
    ItemStackHandler inputSlots = new ItemStackHandler(2){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 1) {
                return stack.func_77973_b() == Items.field_151122_aG;
            }
            if (slot == 0) {
                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
                return enchants != null && enchants.size() > 0;
            }
            return stack.func_77973_b() == Items.field_151134_bR;
        }
    };
    public static final int CAPACITY = 16000;
    ItemStackHandler outputSlots = new ItemStackHandler(2);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 160000);
    public static ForgeConfigSpec.IntValue POWERCONF;
    public static ForgeConfigSpec.IntValue FLUIDCOST;
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    public FluidTankBase tank = new FluidTankBase(this, 16000, p -> p.getFluid().func_207185_a(DataTags.EXPERIENCE));

    public TileDisenchant() {
        super(TileRegistry.disenchanter);
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        ItemStack input = this.inputSlots.getStackInSlot(0);
        if (input.func_190926_b() || input.func_77973_b().func_206844_a(DataTags.DISENCHANTER_IMMUNE)) {
            return;
        }
        Integer cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        if ((Integer)FLUIDCOST.get() > 0 && this.tank.getFluidAmount() < (Integer)FLUIDCOST.get()) {
            return;
        }
        ItemStack book = this.inputSlots.getStackInSlot(1);
        if (book.func_77973_b() != Items.field_151122_aG || !this.outputSlots.getStackInSlot(0).func_190926_b() || !this.outputSlots.getStackInSlot(1).func_190926_b() || input.func_190916_E() != 1) {
            return;
        }
        LinkedHashMap outEnchants = Maps.newLinkedHashMap();
        Map inputEnchants = EnchantmentHelper.func_82781_a((ItemStack)input);
        Enchantment keyMoved = null;
        Iterator iterator = inputEnchants.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            keyMoved = (Enchantment)entry.getKey();
            outEnchants.put(keyMoved, (Integer)entry.getValue());
        }
        if (outEnchants.size() == 0 || keyMoved == null) {
            return;
        }
        if (this.field_145850_b.field_73012_v.nextDouble() < 0.5) {
            UtilSound.playSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_190021_aL);
        } else {
            UtilSound.playSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_187698_i);
        }
        this.energy.extractEnergy(cost, false);
        if ((Integer)FLUIDCOST.get() > 0) {
            this.tank.drain((Integer)FLUIDCOST.get(), IFluidHandler.FluidAction.EXECUTE);
        } else if ((Integer)FLUIDCOST.get() < 0) {
            Fluid newFluid = (Fluid)FluidXpJuiceHolder.STILL.get();
            if (!this.getFluid().isEmpty()) {
                newFluid = this.getFluid().getFluid();
            }
            this.tank.fill(new FluidStack(newFluid, -1 * (Integer)FLUIDCOST.get()), IFluidHandler.FluidAction.EXECUTE);
        }
        inputEnchants.remove(keyMoved);
        ItemStack eBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        EnchantmentHelper.func_82782_a((Map)outEnchants, (ItemStack)eBook);
        this.inputSlots.extractItem(1, 1, false);
        this.outputSlots.insertItem(0, eBook, false);
        if (input.func_77973_b() == Items.field_151134_bR && inputEnchants.size() == 0) {
            ModCyclic.LOGGER.info("book size zero");
            this.inputSlots.extractItem(0, 64, false);
            this.inputSlots.insertItem(0, new ItemStack((IItemProvider)Items.field_151122_aG), false);
        } else if (input.func_77973_b() == Items.field_151134_bR) {
            ModCyclic.LOGGER.info("book normal flow");
            ItemStack inputCopy = new ItemStack((IItemProvider)Items.field_151134_bR);
            EnchantmentHelper.func_82782_a((Map)inputEnchants, (ItemStack)inputCopy);
            this.inputSlots.extractItem(0, 64, false);
            this.inputSlots.insertItem(0, inputCopy, false);
        } else {
            ModCyclic.LOGGER.info("non-book set as removed from item");
            EnchantmentHelper.func_82782_a((Map)inputEnchants, (ItemStack)input);
        }
        input = this.inputSlots.getStackInSlot(0);
        inputEnchants = EnchantmentHelper.func_82781_a((ItemStack)input);
        if (!input.func_190926_b() && inputEnchants.size() == 0 && this.outputSlots.getStackInSlot(1).func_190926_b()) {
            this.outputSlots.insertItem(1, input.func_77946_l(), false);
            this.inputSlots.extractItem(0, 64, false);
        }
    }

    @Override
    public int getEnergy() {
        return this.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerDisenchant(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
        }
        return 0;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    static enum Fields {
        REDSTONE,
        TIMER;

    }
}

