/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.creativebattery;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilDirection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileBatteryInfinite
extends TileEntityBase
implements ITickableTileEntity {
    static final int MAX = 960000000;
    CustomEnergyStorage energy = new CustomEnergyStorage(960000000, 960000000);
    private Map<Direction, Boolean> poweredSides;
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);

    public TileBatteryInfinite() {
        super(TileRegistry.battery_infinite);
        this.poweredSides = new HashMap<Direction, Boolean>();
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, true);
        }
    }

    public boolean getSideHasPower(Direction side) {
        return this.poweredSides.get(side);
    }

    public int getSideField(Direction side) {
        return this.getSideHasPower(side) ? 1 : 0;
    }

    public void setSideField(Direction side, int pow) {
        this.poweredSides.put(side, pow == 1);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, tag.func_74767_n("flow_" + f.func_176742_j()));
        }
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            tag.func_74757_a("flow_" + f.func_176742_j(), this.poweredSides.get(f).booleanValue());
        }
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        return super.func_189515_b(tag);
    }

    public ITextComponent getDisplayName() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public void func_73660_a() {
        this.energy.receiveEnergy(960000000, false);
        this.tickCableFlow();
    }

    private void tickCableFlow() {
        for (Direction exportToSide : UtilDirection.getAllInDifferentOrder()) {
            if (!this.poweredSides.get(exportToSide).booleanValue()) continue;
            this.moveEnergy(exportToSide, 240000000);
        }
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case D: {
                return this.getSideField(Direction.DOWN);
            }
            case E: {
                return this.getSideField(Direction.EAST);
            }
            case N: {
                return this.getSideField(Direction.NORTH);
            }
            case S: {
                return this.getSideField(Direction.SOUTH);
            }
            case U: {
                return this.getSideField(Direction.UP);
            }
            case W: {
                return this.getSideField(Direction.WEST);
            }
        }
        return -1;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case D: {
                this.setSideField(Direction.DOWN, value % 2);
                break;
            }
            case E: {
                this.setSideField(Direction.EAST, value % 2);
                break;
            }
            case N: {
                this.setSideField(Direction.NORTH, value % 2);
                break;
            }
            case S: {
                this.setSideField(Direction.SOUTH, value % 2);
                break;
            }
            case U: {
                this.setSideField(Direction.UP, value % 2);
                break;
            }
            case W: {
                this.setSideField(Direction.WEST, value % 2);
            }
        }
    }

    static enum Fields {
        N,
        E,
        S,
        W,
        U,
        D;

    }
}

