/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.util.UtilEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class LaunchBlock
extends BlockBase {
    private static final float ANGLE = 90.0f;
    protected static final VoxelShape PRESSED_AABB = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)0.5, (double)15.0);
    boolean sneakPlayerAvoid = true;
    boolean doRedstone;

    public LaunchBlock(AbstractBlock.Properties properties, boolean doRedstone) {
        super(properties.func_200942_a().func_200943_b(0.5f));
        this.doRedstone = doRedstone;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return PRESSED_AABB;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return false;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return LaunchBlock.func_220064_c((IBlockReader)worldIn, (BlockPos)blockpos) || LaunchBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (this.sneakPlayerAvoid && entity instanceof PlayerEntity && ((PlayerEntity)entity).func_213453_ef()) {
            return;
        }
        if (worldIn.field_72995_K) {
            UtilEntity.launch(entity, 90.0f, this.getPower(worldIn, pos));
        } else if (entity instanceof PlayerEntity) {
            // empty if block
        }
    }

    private float getPower(World world, BlockPos pos) {
        if (!this.doRedstone) {
            return 1.6f;
        }
        int power = 0;
        for (Direction direction : Direction.values()) {
            int localPow;
            if (direction == Direction.UP || (localPow = world.func_175651_c(pos.func_177972_a(direction), direction)) <= power) continue;
            power = localPow;
        }
        float ratio = (float)(power + 2) / 16.0f;
        return 2.4f * ratio;
    }
}

