/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergyapi.impl.storage;

import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.enviroenergyapi.api.storage.IEEStorage;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;

public class EnergyStorage
implements IEEStorage {
    protected final int voltage;
    protected int current;
    protected final int currentCapacity;
    protected final int currentReceiveMax;
    protected final int currentExtractMax;

    public EnergyStorage(int voltage) {
        this(voltage, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public EnergyStorage(int voltage, int maxCurrent) {
        this(voltage, maxCurrent, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public EnergyStorage(int voltage, int maxCurrent, int maxTransferCurrent) {
        this(voltage, maxCurrent, maxTransferCurrent, maxTransferCurrent);
    }

    public EnergyStorage(int voltage, int maxCurrent, int maxCurrentReceive, int maxCurrentExtract) {
        this.voltage = voltage;
        this.current = 0;
        this.currentCapacity = maxCurrent;
        this.currentReceiveMax = maxCurrentReceive;
        this.currentExtractMax = maxCurrentExtract;
    }

    @Override
    public Energy extractEnergy(@Nonnull Energy requested, boolean sim) {
        if (requested.getVoltage() != this.voltage) {
            return Energy.ZERO;
        }
        Energy req = Energy.minCurrent(new Energy(this.voltage, this.getCurrentStored()), Energy.minCurrent(this.getMaxExtract(), requested));
        if (!sim) {
            this.current -= req.getCurrent();
        }
        return req;
    }

    @Override
    public Energy getMaxExtract() {
        return new Energy(this.voltage, Math.min(this.getCurrentStored(), this.currentExtractMax));
    }

    @Override
    public int getExtractVoltage() {
        return this.voltage;
    }

    @Override
    public Energy receiveEnergy(@Nonnull Energy provided, boolean sim) {
        if (provided.getVoltage() != this.voltage) {
            return Energy.ZERO;
        }
        Energy pro = Energy.minCurrent(new Energy(this.voltage, this.getCurrentRoom()), Energy.minCurrent(this.getMaxReceive(), provided));
        if (!sim) {
            this.current += pro.getCurrent();
        }
        return pro;
    }

    @Override
    public Energy getMaxReceive() {
        return new Energy(this.voltage, Math.min(this.getCurrentRoom(), this.currentReceiveMax));
    }

    @Override
    public int getReceiveVoltage() {
        return this.voltage;
    }

    @Override
    public int getCurrentStored() {
        return this.current;
    }

    @Override
    public int getCurrentCapacity() {
        return this.currentCapacity;
    }

    public EnergyStorage readFromNBT(CompoundNBT tag) {
        this.current = tag.func_74762_e("curr_st");
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT tag) {
        tag.func_74768_a("curr_st", this.current);
        return tag;
    }

    public void setStoredCurrent(int current) {
        this.current = current;
        if (this.current > this.currentCapacity) {
            this.current = this.currentCapacity;
        } else if (this.current < 0) {
            this.current = 0;
        }
    }

    public void modifyStoredCurrent(int current) {
        this.current += current;
        if (this.current > this.currentCapacity) {
            this.current = this.currentCapacity;
        } else if (this.current < 0) {
            this.current = 0;
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT tag) {
        this.current = tag.func_74764_b("stored") ? tag.func_74762_e("stored") : this.current;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("stored", this.current);
        return tag;
    }
}

