/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergyapi.api;

import javax.annotation.Nonnull;

@Nonnull
public class Energy {
    public static final Energy ZERO = new Energy(0, 0);
    protected final int voltage;
    protected int current;

    public Energy(int voltage) {
        this(voltage, 0);
    }

    public Energy(int voltage, int current) {
        this.voltage = voltage;
        this.current = current;
    }

    public String toString() {
        return "[" + this.voltage + ":" + this.current + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Energy)) {
            return false;
        }
        return ((Energy)obj).voltage == this.voltage && ((Energy)obj).current == this.current;
    }

    public int getVoltage() {
        return this.voltage;
    }

    public int getCurrent() {
        return this.current;
    }

    public long getPotential() {
        return Energy.getPotential(this.voltage, this.current);
    }

    public void addCurrent(int current) {
        this.current += current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public boolean canAdd(@Nonnull Energy add) {
        return this.voltage == add.getVoltage();
    }

    public static boolean canAdd(@Nonnull Energy one, @Nonnull Energy two) {
        if (one == null || two == null) {
            return false;
        }
        return one.getVoltage() == two.getVoltage();
    }

    public static boolean add(@Nonnull Energy one, @Nonnull Energy two) {
        if (Energy.canAdd(one, two)) {
            one.addCurrent(two.getCurrent());
            return true;
        }
        return false;
    }

    public static long getPotential(@Nonnull Energy energy) {
        return ZERO.equals(energy) ? energy.getPotential() : 0L;
    }

    @Nonnull
    public static Energy fromPotential(int voltage, long potential) {
        if (voltage <= 0) {
            return new Energy(0);
        }
        return new Energy(voltage, (int)(potential / (long)voltage));
    }

    public static boolean canLosslessConvert(@Nonnull Energy energy, int newVoltage) {
        long pot;
        return energy != null && (pot = energy.getPotential()) % (long)newVoltage == 0L;
    }

    public static int getVoltage(@Nonnull Energy energy) {
        return ZERO.equals(energy) ? energy.getVoltage() : 0;
    }

    @Nonnull
    public static Energy maxPotential(@Nonnull Energy one, @Nonnull Energy two) {
        if (ZERO.equals(one) || ZERO.equals(two)) {
            return ZERO;
        }
        return one.getPotential() >= two.getPotential() ? one : two;
    }

    @Nonnull
    public static Energy maxVoltage(@Nonnull Energy one, @Nonnull Energy two) {
        if (ZERO.equals(one) || ZERO.equals(two)) {
            return ZERO;
        }
        return one.getVoltage() >= two.getVoltage() ? one : two;
    }

    @Nonnull
    public static Energy maxCurrent(@Nonnull Energy one, @Nonnull Energy two) {
        if (ZERO.equals(one) || ZERO.equals(two)) {
            return ZERO;
        }
        return one.getCurrent() >= two.getCurrent() ? one : two;
    }

    @Nonnull
    public static Energy minPotential(@Nonnull Energy one, @Nonnull Energy two) {
        if (ZERO.equals(one) || ZERO.equals(two)) {
            return ZERO;
        }
        return one.getPotential() <= two.getPotential() ? one : two;
    }

    @Nonnull
    public static Energy minVoltage(@Nonnull Energy one, @Nonnull Energy two) {
        if (ZERO.equals(one) || ZERO.equals(two)) {
            return ZERO;
        }
        return one.getVoltage() <= two.getVoltage() ? one : two;
    }

    @Nonnull
    public static Energy minCurrent(@Nonnull Energy one, @Nonnull Energy two) {
        if (ZERO.equals(one) || ZERO.equals(two)) {
            return ZERO;
        }
        return one.getCurrent() <= two.getCurrent() ? one : two;
    }

    public static long getPotential(int voltage, int current) {
        return (long)voltage * (long)current;
    }

    public static int getCurrent(long potential, int voltage) {
        return (int)(potential / (long)voltage);
    }

    public static long getRemainderAfterCurrent(long potential, int voltage) {
        int current = Energy.getCurrent(potential, voltage);
        long currentToPotential = Energy.getPotential(voltage, current);
        return potential - currentToPotential;
    }

    public static boolean isNullOrEmpty(@Nonnull Energy pwr) {
        return ZERO.equals(pwr) ? true : pwr.getPotential() == 0L;
    }
}

