/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.m_machines.m_crystalizer.datapack;

import com.valkyrieofnight.enviroenergyapi.util.EnergyUtil;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipe;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;

public class CrystallizerRecipe
extends VLRecipe {
    protected Ingredient<ItemStack> input1;
    protected Ingredient<ItemStack> input2;
    protected Ingredient<ItemStack> input3;
    protected Ingredient<FluidStack> fluid;
    protected Ingredient<ItemStack> output;
    protected Provider<Integer> energyCost;

    public CrystallizerRecipe(Ingredient<ItemStack> i1, Ingredient<ItemStack> i2, Ingredient<ItemStack> i3, Ingredient<FluidStack> fluid, Ingredient<ItemStack> output, Provider<Integer> energyCost) {
        this.input1 = i1;
        this.input2 = i2;
        this.input3 = i3;
        this.fluid = fluid;
        this.output = output;
        this.energyCost = energyCost;
    }

    public CrystallizerRecipe(PacketBuffer buffer) {
        super(buffer);
    }

    public boolean testInput(@Nonnull ConditionContainerProvider provider, @Nonnull ItemStack is1, @Nonnull ItemStack is2, @Nonnull ItemStack is3, FluidStack fluid) {
        boolean t1 = this.input1 != null ? this.input1.test(provider, (Object)is1) : true;
        boolean t2 = this.input2 != null ? this.input2.test(provider, (Object)is2) : true;
        boolean t3 = this.input3 != null ? this.input3.test(provider, (Object)is3) : true;
        boolean t4 = this.fluid != null ? this.fluid.test(provider, (Object)fluid) : true;
        return t1 && t2 && t3 && t4;
    }

    public ItemStack[] getInputItems(@Nonnull ConditionContainerProvider provider) {
        ItemStack i1 = this.input1 != null ? (ItemStack)this.input1.request(provider).iterator().next() : ItemStack.field_190927_a;
        ItemStack i2 = this.input2 != null ? (ItemStack)this.input2.request(provider).iterator().next() : ItemStack.field_190927_a;
        ItemStack i3 = this.input3 != null ? (ItemStack)this.input3.request(provider).iterator().next() : ItemStack.field_190927_a;
        return new ItemStack[]{i1, i2, i3};
    }

    public FluidStack getInputFluid(@Nonnull ConditionContainerProvider provider) {
        return this.fluid != null ? (FluidStack)this.fluid.request(provider).iterator().next() : FluidStack.EMPTY;
    }

    public long getRequiredEnergy(@Nonnull ConditionContainerProvider provider) {
        return EnergyUtil.FE_CONVERTER.convertToPotential((Integer)((Number)this.energyCost.request(provider)));
    }

    public ItemStack getOutput(@Nonnull ConditionContainerProvider provider) {
        return (ItemStack)this.output.request(provider).iterator().next();
    }

    protected void writeRecipeData(PacketBuffer packetBuffer) {
        this.input1.writePacketData(packetBuffer);
        this.input2.writePacketData(packetBuffer);
        this.input3.writePacketData(packetBuffer);
        this.fluid.writePacketData(packetBuffer);
        this.output.writePacketData(packetBuffer);
        DeserializerUtils.writeProviderToPacket(this.energyCost, (PacketBuffer)packetBuffer);
    }

    protected void readRecipeData(PacketBuffer packetBuffer) {
        this.input1 = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.input2 = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.input3 = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.fluid = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.output = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.energyCost = DeserializerUtils.readProviderFromPacket((PacketBuffer)packetBuffer);
    }

    protected boolean canWriteData() {
        return this.input1.isValid() && this.input2.isValid() && this.input3.isValid() && this.fluid.isValid() && this.output.isValid() && this.energyCost.isValid();
    }
}

