/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.m_machines.m_crusher.datapack;

import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipe;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class CrusherRecipe
extends VLRecipe {
    protected Ingredient<ItemStack> input;
    protected Ingredient<ItemStack> output;
    protected Provider<Integer> duration;

    public CrusherRecipe(Ingredient<ItemStack> input, Ingredient<ItemStack> output, Provider<Integer> duration) {
        this.input = input;
        this.output = output;
        this.duration = duration;
    }

    public CrusherRecipe(PacketBuffer buffer) {
        super(buffer);
    }

    public boolean testInput(ConditionContainerProvider provider, ItemStack in) {
        return this.input.test(provider, (Object)in);
    }

    public ItemStack getInput(ConditionContainerProvider provider) {
        List col = this.input.request(provider);
        if (col.size() >= 1) {
            return (ItemStack)col.iterator().next();
        }
        return (ItemStack)this.input.request(provider).iterator().next();
    }

    public int getInputCount(ConditionContainerProvider provider) {
        return this.input.requestAmount(provider);
    }

    public ItemStack getOutput(ConditionContainerProvider provider) {
        List col = this.output.request(provider);
        if (col.size() >= 1) {
            return (ItemStack)col.iterator().next();
        }
        return ItemStack.field_190927_a;
    }

    public int getOutputCount(ConditionContainerProvider provider) {
        return this.output.requestAmount(provider);
    }

    public int getDuration(ConditionContainerProvider provider) {
        return (Integer)this.duration.request(provider);
    }

    protected void writeRecipeData(PacketBuffer packetBuffer) {
        this.input.writePacketData(packetBuffer);
        this.output.writePacketData(packetBuffer);
        DeserializerUtils.writeProviderToPacket(this.duration, (PacketBuffer)packetBuffer);
    }

    protected void readRecipeData(PacketBuffer packetBuffer) {
        this.input = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.output = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.duration = DeserializerUtils.readProviderFromPacket((PacketBuffer)packetBuffer);
    }

    protected boolean canWriteData() {
        return this.input.isValid() && this.output.isValid() && this.duration.isValid();
    }
}

