/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.types.cat_list_machine.obj;

import com.valkyrieofnight.envirocore.core.tile.machine.ECEnergyReceiverTile;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.rec.AbstractCatListRecipe;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.rec.AbstractCatListRecipeRegistry;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.nw.SetModePacket;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.nw.SetRecipePacket;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.ui.AbstractCatListMachineContainer;
import com.valkyrieofnight.vlib.core.obj.container.item.VLInventory;
import com.valkyrieofnight.vlib.core.obj.container.item.base.IVLSerializableInventory;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.IProvideGui;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.network.BaseTilePacket;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.ModuleBuilders;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.TrackerModule;
import com.valkyrieofnight.vlib.core.obj.tileentity.module.base.IModuleBuilder;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.obj.IOMode;
import com.valkyrieofnight.vlib.core.util.obj.InventoryUtils;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;

public abstract class AbstractCatListMachineTile<RECIPE extends AbstractCatListRecipe, CONTAINER extends AbstractCatListMachineContainer>
extends ECEnergyReceiverTile
implements IProvideGui<CONTAINER> {
    protected VLInventory input = new VLInventory(new IOMode[]{IOMode.IN});
    protected VLInventory output = new VLInventory(new IOMode[]{IOMode.OUT});
    protected RECIPE currentRecipe;
    protected Mode mode;
    protected TrackerModule tracker;

    public AbstractCatListMachineTile(TileEntityType<?> blockEntityType_1, int voltage, long potential) {
        super(blockEntityType_1, voltage, potential);
        this.setupInventory(new RelativeDirection[]{RelativeDirection.FORWARD}, new IVLSerializableInventory[]{this.input, this.output});
        this.mode = Mode.SINGLE;
        this.setupMainModule(ModuleBuilders.noAcceleration().addModule((IModuleBuilder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)((TrackerModule.Builder)ModuleBuilders.tracker().init(m -> {
            this.tracker = m;
        })).canStartProcess(this::canStartProcess)).checkAndValidateProcessable(this::checkAndValidateProcessable)).canCompleteProcess(this::canCompleteProcess)).onProcessTick(this::onProcessTicks)).onComplete(this::onCompleteProcess)).processDuration(this::getProcessDuration)));
    }

    public float getProgressScale() {
        return this.tracker.getProgressScale();
    }

    private boolean isRecipeInputValid() {
        int count = ((AbstractCatListRecipe)((Object)this.currentRecipe)).getInputCount(this.conditionProvider);
        return ((AbstractCatListRecipe)((Object)this.currentRecipe)).testInput(this.conditionProvider, this.input.func_70301_a(0)) && this.input.func_70301_a(0).func_190916_E() >= count;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        if (type != SaveDataType.ITEM && this.currentRecipe != null) {
            nbt.func_74778_a("recipe", this.currentRecipe.getRecipeID().toString());
        }
        nbt.func_74768_a("mode", this.mode.ordinal());
        return super.save(nbt, type);
    }

    @Override
    public void load(CompoundNBT nbt, SaveDataType type) {
        if (type != SaveDataType.ITEM && nbt.func_74764_b("recipe")) {
            this.currentRecipe = this.getRegistry().getRecipe(VLID.from((String)nbt.func_74779_i("recipe")));
        }
        if (nbt.func_74764_b("mode")) {
            this.mode = Mode.getFromOrdinal(nbt.func_74762_e("mode"));
        }
        super.load(nbt, type);
    }

    protected boolean canStartProcess() {
        if (this.currentRecipe != null) {
            ((AbstractCatListRecipe)((Object)this.currentRecipe)).testInput(this.conditionProvider, this.input.func_70301_a(0));
        }
        if (this.currentRecipe != null) {
            return this.isRecipeInputValid() && InventoryUtils.canInsertAll((IInventory)this.output, (int)0, (ItemStack)((AbstractCatListRecipe)((Object)this.currentRecipe)).getOutput(this.conditionProvider));
        }
        return false;
    }

    protected int checkAndValidateProcessable(int i) {
        if (this.currentRecipe == null || !((AbstractCatListRecipe)((Object)this.currentRecipe)).testInput(this.conditionProvider, this.input.func_70301_a(0))) {
            this.tracker.reset();
        }
        if (this.energyStorage.getPotentialStored() >= (long)(this.getPotentialPerTick() * i)) {
            return i;
        }
        return 0;
    }

    protected boolean canCompleteProcess() {
        if (this.currentRecipe == null || !this.isRecipeInputValid()) {
            this.tracker.reset();
            return false;
        }
        if (this.output.func_70301_a(0).equals(ItemStack.field_190927_a)) {
            return true;
        }
        ItemStack o = ((AbstractCatListRecipe)((Object)this.currentRecipe)).getOutput(this.conditionProvider);
        return InventoryUtils.canInsertAll((IInventory)this.output, (int)0, (ItemStack)o);
    }

    protected void onProcessTicks(int i) {
        if (this.currentRecipe == null) {
            this.tracker.reset();
        } else {
            this.energyStorage.extractInternal(this.getPotentialPerTick() * i, false);
        }
        this.func_70296_d();
    }

    protected void onCompleteProcess() {
        ItemStack in;
        if (this.currentRecipe == null) {
            return;
        }
        ItemStack o = ((AbstractCatListRecipe)((Object)this.currentRecipe)).getOutput(this.conditionProvider);
        InventoryUtils.extractItem((IInventory)this.input, (int)0, (int)((AbstractCatListRecipe)((Object)this.currentRecipe)).getInputCount(this.conditionProvider), (boolean)false);
        InventoryUtils.insertItem((IInventory)this.output, (int)0, (ItemStack)o, (boolean)false);
        if (this.mode == Mode.SINGLE) {
            this.currentRecipe = null;
        }
        if (this.mode == Mode.FINISH_STACK && ((in = this.input.func_70301_a(0)).equals(ItemStack.field_190927_a) || in.func_190916_E() <= 0)) {
            this.currentRecipe = null;
        }
    }

    protected int getProcessDuration() {
        return this.currentRecipe != null ? ((AbstractCatListRecipe)((Object)this.currentRecipe)).getDuration(this.conditionProvider) : 100;
    }

    public void receiveData(BaseTilePacket packet) {
        super.receiveData(packet);
        if (packet instanceof SetRecipePacket) {
            this.currentRecipe = this.getRegistry().getRecipe(((SetRecipePacket)packet).getRecipe());
        }
        if (packet instanceof SetModePacket) {
            this.mode = ((SetModePacket)packet).getMode();
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public RECIPE getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipe(VLID recipeID) {
        this.currentRecipe = this.getRegistry().getRecipe(recipeID);
        this.tracker.reset();
    }

    public abstract AbstractCatListRecipeRegistry<RECIPE> getRegistry();

    public abstract int getPotentialPerTick();

    public static enum Mode {
        SINGLE("single"),
        FINISH_STACK("stack"),
        CONTINUOUS("continuous");

        private final String name;
        public static final Mode[] ALL;

        private Mode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return "tooltip.envirocore." + this.name;
        }

        public static Mode getFromOrdinal(int ordinal) {
            return ALL[ordinal % ALL.length];
        }

        static {
            ALL = Mode.values();
        }
    }
}

