/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.rec;

import com.google.common.collect.Lists;
import com.valkyrieofnight.envirocore.core.types.cat_list_machine.dp.cat.AbstractCategoryData;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.recipe.VLRecipe;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public abstract class AbstractCatListRecipe
extends VLRecipe {
    protected List<VLID> categories;
    protected Color4 color;
    protected Ingredient<ItemStack> input;
    protected Ingredient<ItemStack> output;
    protected Provider<Integer> duration;

    public AbstractCatListRecipe(@Nonnull List<VLID> cats, Color4 col, @Nonnull Ingredient<ItemStack> i, @Nonnull Ingredient<ItemStack> o, @Nonnull Provider<Integer> d) {
        this.categories = cats;
        if (!this.categories.contains(AbstractCategoryData.CATEGORY_ALL)) {
            this.categories.add(AbstractCategoryData.CATEGORY_ALL);
        }
        this.color = col;
        this.input = i;
        this.output = o;
        this.duration = d;
    }

    public AbstractCatListRecipe(PacketBuffer buffer) {
        super(buffer);
    }

    protected void writeRecipeData(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.categories.size());
        for (VLID pid : this.categories) {
            packetBuffer.func_180714_a(pid.toString());
        }
        packetBuffer.writeInt(this.color.getRGBA());
        this.input.writePacketData(packetBuffer);
        this.output.writePacketData(packetBuffer);
        this.duration.writePacketData(packetBuffer);
        this.writeOtherToPacket(packetBuffer);
    }

    protected void readRecipeData(PacketBuffer packetBuffer) {
        int catCount = packetBuffer.readInt();
        this.categories = Lists.newArrayList();
        for (int i = 0; i < catCount; ++i) {
            this.categories.add(VLID.from((String)packetBuffer.func_218666_n()));
        }
        this.color = new Color4(packetBuffer.readInt());
        this.input = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.output = Ingredient.createFromPacket((PacketBuffer)packetBuffer);
        this.duration = DeserializerUtils.readProviderFromPacket((PacketBuffer)packetBuffer);
        this.readOtherFromPacket(packetBuffer);
    }

    public abstract String getUnlocalizedCategory(int var1);

    public abstract String getUnlocalizedTitle();

    protected abstract void writeOtherToPacket(PacketBuffer var1);

    protected abstract void readOtherFromPacket(PacketBuffer var1);

    public List<VLID> getCategories() {
        return this.categories;
    }

    public Color4 getColor() {
        return this.color;
    }

    public int getDuration(ConditionContainerProvider ccp) {
        return (Integer)this.duration.request(ccp);
    }

    public boolean testInput(ConditionContainerProvider ccp, ItemStack in) {
        return this.input.test(ccp, (Object)in);
    }

    public boolean testOutput(ConditionContainerProvider ccp, ItemStack out) {
        return this.output.test(ccp, (Object)out);
    }

    public int getInputCount(ConditionContainerProvider ccp) {
        return this.input.requestAmount(ccp);
    }

    public abstract ItemStack getOutput(ConditionContainerProvider var1);

    public abstract List<ItemStack> getInput(ConditionContainerProvider var1);
}

