/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.energy;

import com.valkyrieofnight.enviroenergyapi.impl.storage.PotentialStorage;
import com.valkyrieofnight.enviroenergyapi.util.EnergyUtil;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action;
import net.minecraftforge.energy.IEnergyStorage;

public class UniPotentialBattery
extends PotentialStorage
implements IEnergyStorage {
    protected Action markDirty = null;

    public UniPotentialBattery(long potentialCapacity) {
        super(potentialCapacity);
    }

    public UniPotentialBattery(long potentialCapacity, long maxTransfer) {
        super(potentialCapacity, maxTransfer);
    }

    public UniPotentialBattery(long potentialCapacity, long maxExtract, long maxReceive) {
        super(potentialCapacity, maxExtract, maxReceive);
    }

    public void setMarkDirtyAction(Action markDirty) {
        this.markDirty = markDirty;
    }

    private void markDirty() {
        if (this.markDirty != null) {
            this.markDirty.execute();
        }
    }

    public long receiveInternal(long potential, boolean sim) {
        long receivable = Math.min(this.getPotentialRoom(), potential);
        if (!sim) {
            this.potential += receivable;
            this.markDirty();
        }
        return receivable;
    }

    public long extractInternal(long potential, boolean sim) {
        long extractable = Math.min(this.potential, potential);
        if (!sim) {
            this.potential -= extractable;
            this.markDirty();
        }
        return extractable;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        long rePot = EnergyUtil.FE_CONVERTER.convertToPotential(maxReceive);
        long recie = Math.min(Integer.MAX_VALUE, Math.min(this.getPotentialRoom(), Math.min(this.maxReceive, rePot)));
        if (recie < rePot) {
            recie -= EnergyUtil.FE_CONVERTER.getConvertibleRemainder(recie);
        }
        if (!simulate) {
            this.potential += recie;
            this.markDirty();
        }
        return (Integer)EnergyUtil.FE_CONVERTER.convertFromPotential(recie);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        long exPot = EnergyUtil.FE_CONVERTER.convertToPotential(maxExtract);
        long extra = Math.min(Integer.MAX_VALUE, Math.min(this.potential, Math.min(this.maxExtract, exPot)));
        if (extra < exPot) {
            extra -= extra % (long)EnergyUtil.FE_CONVERTER.getNativeVoltage();
        }
        if (!simulate) {
            this.potential -= extra;
            this.markDirty();
        }
        return (Integer)EnergyUtil.FE_CONVERTER.convertFromPotential(extra);
    }

    public int getEnergyStored() {
        return (Integer)EnergyUtil.FE_CONVERTER.convertFromPotential(this.potential);
    }

    public int getMaxEnergyStored() {
        return (Integer)EnergyUtil.FE_CONVERTER.convertFromPotential(this.potentialCapacity);
    }

    @Override
    public boolean canExtract() {
        return super.canExtract();
    }

    @Override
    public boolean canReceive() {
        return super.canReceive();
    }
}

