/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.block;

import com.valkyrieofnight.vlib.core.obj.block.base.BlockProps;
import com.valkyrieofnight.vlib.core.obj.block.base.color.IColorableBlockWithTile;
import com.valkyrieofnight.vlib.core.obj.block.withtile.VLTileBlock;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.color.IColorProviderTile;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.module.config.IConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;

public abstract class EColoredSlaveBlock
extends VLTileBlock
implements IColorableBlockWithTile {
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.func_177719_a((String)"light_level", (int)0, (int)15);
    private Color4 baseColor = new Color4(255, 255, 255, 255);

    public EColoredSlaveBlock(String block, BlockProps props, Class<? extends TileEntity> tile) {
        super(new VLID("envirocore", block), props.lightLevel(EColoredSlaveBlock::getLightLevel), tile);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public EColoredSlaveBlock(VLID block, BlockProps props, Class<? extends TileEntity> tile) {
        super(block, props.lightLevel(EColoredSlaveBlock::getLightLevel), tile);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIGHT_LEVEL});
    }

    public static int getLightLevel(BlockState state) {
        return state.func_235901_b_((Property)LIGHT_LEVEL) ? (Integer)state.func_177229_b((Property)LIGHT_LEVEL) : 0;
    }

    public void setBaseColor(Color4 col) {
        this.baseColor = col;
    }

    public int getColor(IBlockDisplayReader reader, BlockState blockState, BlockPos blockPos, int i) {
        if (reader == null || blockPos == null) {
            return this.baseColor.getRGBA();
        }
        TileEntity te = reader.func_175625_s(blockPos);
        if (te instanceof IColorProviderTile) {
            return ((IColorProviderTile)te).getColor(i);
        }
        return this.baseColor.getRGBA();
    }

    public int getColor(ItemStack itemStack, int i) {
        return this.baseColor.getRGBA();
    }

    public void loadColor(IConfig config, int r, int g, int b) {
        this.loadColor(config, new Color4(r, g, b));
    }

    public void loadColor(IConfig config, Color4 c) {
        IConfig color = config.getSubConfig("default_base_color");
        this.setBaseColor(new Color4(color.getInt("r", c.getRi(), 0, 255, new String[0]), color.getInt("g", c.getGi(), 0, 255, new String[0]), color.getInt("b", c.getBi(), 0, 255, new String[0])));
    }

    public Color4 getBaseColor() {
        return this.baseColor;
    }

    public int[] getAllColorChannels() {
        return new int[]{0};
    }

    public int[] getAllColorableChannels() {
        return new int[]{0};
    }
}

