/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.common.inventory.Slots;
import shetiphian.enderchests.common.item.ItemEnderBag;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ContainerEnderChest
extends Container {
    private TileEntityEnderChest chestTile;
    private InventoryInternal chest;
    private String owner;
    private final IntReferenceHolder size = IntReferenceHolder.func_221492_a();
    private Runnable callbackInventoryChange;

    public ContainerEnderChest(int id, PlayerInventory invPlayer, TileEntityEnderChest tile) {
        super(Values.Container.ENDER_CHEST, id);
        this.callbackInventoryChange = () -> {};
        this.common_setup(invPlayer, tile.getChest(), tile.getOwnerName());
        this.chestTile = tile;
        this.chestTile.onContainerOpen((TileEntity)this.chestTile, (IInventory)this.chest, invPlayer.field_70458_d);
    }

    public ContainerEnderChest(int id, PlayerInventory invPlayer, InventoryInternal chest, String owner) {
        super(Values.Container.ENDER_BAG, id);
        this.callbackInventoryChange = () -> {};
        this.common_setup(invPlayer, chest, owner);
    }

    private void common_setup(PlayerInventory invPlayer, InventoryInternal chest, String owner) {
        int slotId;
        this.chest = chest;
        this.owner = ChestInfoHelper.formatChestOwner(owner, true);
        for (slotId = 0; slotId < 54; ++slotId) {
            this.func_75146_a(new Slots.Hideable((IInventory)chest, slotId, 0, 0));
        }
        for (slotId = 0; slotId < 27; ++slotId) {
            this.func_75146_a(new Slot((IInventory)invPlayer, slotId + 9, 0, 0));
        }
        for (slotId = 0; slotId < 9; ++slotId) {
            this.func_75146_a(new Slot((IInventory)invPlayer, slotId, 0, 0));
        }
        this.func_216958_a(this.size).func_221494_a(this.chest.func_70302_i_());
    }

    public void func_75142_b() {
        this.size.func_221494_a(this.chest.func_70302_i_());
        super.func_75142_b();
    }

    public boolean isParentTile(TileEntityEnderChest tile) {
        return this.chestTile == tile;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_75137_b(int id, int value) {
        super.func_75137_b(id, value);
        if (this.size.func_221495_b() != this.chest.func_70302_i_()) {
            ITextComponent text = this.chest.func_200200_C_();
            String name = text instanceof TranslationTextComponent ? ((TranslationTextComponent)text).func_150268_i() : text.func_150261_e();
            String[] parts = name.split("\\.");
            if (parts.length == 2) {
                ChestHelper.setCapacity((World)Minecraft.func_71410_x().field_71441_e, parts[0], parts[1], (byte)value);
                this.callbackInventoryChange.run();
            } else if (parts.length == 4) {
                ChestHelper.setCapacity((World)Minecraft.func_71410_x().field_71441_e, parts[2], parts[3], (byte)value);
                this.callbackInventoryChange.run();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryChangeCallback(Runnable runnable) {
        this.callbackInventoryChange = runnable;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        ItemStack stack;
        if (clickType == ClickType.SWAP && dragType >= 0 && dragType < 9 && !(stack = player.field_71071_by.func_70301_a(dragType)).func_190926_b() && stack.func_77973_b() instanceof ItemEnderBag && ItemEnderBag.isOpen(stack)) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (this.chestTile != null) {
            this.chestTile.onContainerClosed((TileEntity)this.chestTile, (IInventory)this.chest, player);
        }
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int slotNumber) {
        Slot clickedSlot = (Slot)this.field_75151_b.get(slotNumber);
        if (clickedSlot == null || !clickedSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemInSlot = clickedSlot.func_75211_c();
        if (itemInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack returnStack = itemInSlot.func_77946_l();
        if (slotNumber < 54 ? !this.func_75135_a(itemInSlot, 54, this.field_75151_b.size(), true) : !this.func_75135_a(itemInSlot, 0, this.chest.func_70302_i_(), false)) {
            return ItemStack.field_190927_a;
        }
        if (itemInSlot.func_190916_E() == 0) {
            clickedSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            clickedSlot.func_75218_e();
        }
        if (itemInSlot.func_190916_E() == returnStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        return returnStack;
    }

    public int getChestSize() {
        return this.chest.func_70302_i_();
    }

    public String getOwner() {
        return this.owner;
    }
}

