/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests;

import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import shetiphian.core.common.MyCreativeTab;
import shetiphian.core.common.RegistryHelper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.client.gui.GuiEnderChest;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.item.ItemBlockEnderChest;
import shetiphian.enderchests.common.item.ItemEnderBag;
import shetiphian.enderchests.common.item.ItemEnderPouch;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

@Mod.EventBusSubscriber(modid="enderchests", bus=Mod.EventBusSubscriber.Bus.MOD)
class Register {
    Register() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Values.blockEnderChest = RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockEnderChest(), (String)"enderchests:ender_chest");
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        Values.tileEnderChest = RegistryHelper.register((IForgeRegistry)registry, TileEntityEnderChest::new, (String)"enderchests:ender_chest.tile", (Block[])new Block[]{Values.blockEnderChest});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Values.tabEnderChests = new MyCreativeTab("EnderChests");
        RegistryHelper.register((IForgeRegistry)registry, (BlockItem)new ItemBlockEnderChest(Values.blockEnderChest, Register.stackable()));
        Values.itemEnderBag = RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemEnderBag(Register.singleton()), (String)"enderchests:ender_bag");
        RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemEnderPouch(Register.singleton()), (String)"enderchests:ender_pouch");
        Register.setTabIcon();
    }

    private static Item.Properties stackable() {
        return new Item.Properties().func_200916_a((ItemGroup)Values.tabEnderChests);
    }

    private static Item.Properties singleton() {
        return Register.stackable().func_200917_a(1);
    }

    private static void setTabIcon() {
        Values.tabEnderChests.setIcon(new ItemStack((IItemProvider)Values.blockEnderChest));
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(IForgeContainerType.create((windowId, invPlayer, data) -> {
            World world = invPlayer.field_70458_d.func_130014_f_();
            InventoryInternal chest = null;
            try {
                chest = ChestHelper.getChest(world, data.func_218666_n(), data.func_218666_n());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return chest != null ? new ContainerEnderChest(windowId, invPlayer, chest, data.func_218666_n()) : null;
        }).setRegistryName("enderchests:ender_bag"));
        registry.register(IForgeContainerType.create((windowId, invPlayer, data) -> {
            BlockPos pos = data.func_179259_c();
            World world = invPlayer.field_70458_d.func_130014_f_();
            TileEntity tile = world.func_175625_s(pos);
            return tile instanceof TileEntityEnderChest ? new ContainerEnderChest(windowId, invPlayer, (TileEntityEnderChest)tile) : null;
        }).setRegistryName("enderchests:ender_chest"));
    }

    @OnlyIn(value=Dist.CLIENT)
    static void registerScreenFactories() {
        ScreenManager.func_216911_a(Values.Container.ENDER_BAG, GuiEnderChest::new);
        ScreenManager.func_216911_a(Values.Container.ENDER_CHEST, GuiEnderChest::new);
    }
}

