/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.Register;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.client.misc.EventHandlerClient;
import shetiphian.enderchests.client.render.RenderRegistry;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.EventHandler;
import shetiphian.enderchests.modintegration.ModIntegration;

@Mod(value="enderchests")
public class EnderChests {
    public static final String MOD_ID = "enderchests";
    public static EnderChests INSTANCE;
    public static Logger LOGGER;

    public EnderChests() {
        INSTANCE = this;
        LOGGER = LogManager.getLogger((String)MOD_ID);
        IEventBus MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        MOD_EVENT_BUS.register((Object)this);
        MOD_EVENT_BUS.addListener(this::commonSetup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MOD_EVENT_BUS.addListener(this::clientSetup));
        MOD_EVENT_BUS.addListener(this::init);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Configuration.SPEC_CLIENT, "enderchests-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Configuration.SPEC_COMMON, "enderchests.toml");
        MOD_EVENT_BUS.register(Configuration.class);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Values.minecraftDir = FMLPaths.GAMEDIR.get().toAbsolutePath().toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        RenderRegistry.setupNow();
        DeferredWorkQueue.runLater(RenderRegistry::setupLater);
        DeferredWorkQueue.runLater(Register::registerScreenFactories);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
    }

    private void init(InterModEnqueueEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        new ModIntegration();
    }

    private void serverStarted(FMLServerStartedEvent event) {
        ChestHelper.INSTANCE.loadChestData();
    }

    private void serverStopped(FMLServerStoppedEvent event) {
        ChestHelper.INSTANCE.unloadChestData();
        Configuration.CAN_PROCESS_TAGS = false;
    }
}

