/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tools.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class FluidUtils {
    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void color(int color) {
        RenderSystem.color4f((float)FluidUtils.getRed(color), (float)FluidUtils.getGreen(color), (float)FluidUtils.getBlue(color), (float)FluidUtils.getAlpha(color));
    }

    @Nullable
    public static TextureAtlasSprite getFluidTexture(@Nonnull FluidStack stack) {
        FluidAttributes fa = stack.getFluid().getAttributes();
        ResourceLocation still = fa.getStillTexture(stack);
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(still);
    }

    public static int getLiquidColorWithBiome(@Nonnull FluidStack fluid, World world, BlockPos pos) {
        if (world.field_72995_K && fluid.isFluidEqual(new FluidStack((Fluid)Fluids.field_204546_a, 1000))) {
            return BiomeColors.func_228363_c_((IBlockDisplayReader)world, (BlockPos)pos) | 0xFF000000;
        }
        return fluid.getFluid().getAttributes().getColor(fluid);
    }

    public static int getLiquidColorWithBiome(@Nonnull FluidStack fluid, @Nonnull TileEntity tileEntity) {
        return FluidUtils.getLiquidColorWithBiome(fluid, tileEntity.func_145831_w(), tileEntity.func_174877_v());
    }
}

