/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tile;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.container.ContainerDimChest;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.setup.Registration;
import edivad.dimstorage.storage.DimChestStorage;
import edivad.dimstorage.tile.TileFrequencyOwner;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityDimChest
extends TileFrequencyOwner {
    private static final float MIN_MOVABLE_POSITION = 0.0f;
    private static final float MAX_MOVABLE_POSITION = 0.5f;
    private static final float OPENING_SPEED = 0.05f;
    private int openCount;
    public float movablePartState = 0.0f;
    public int rotation;
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();

    public TileEntityDimChest() {
        super((TileEntityType)Registration.DIMCHEST_TILE.get());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!(this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L && this.openCount == this.getStorage().getNumOpen())) {
            this.openCount = this.getStorage().getNumOpen();
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.openCount);
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
        this.movablePartState = this.openCount > 0 ? (this.movablePartState < 0.5f ? (this.movablePartState += 0.05f) : 0.5f) : (this.movablePartState > 0.0f ? (this.movablePartState -= 0.05f) : 0.0f);
    }

    public int getComparatorInput() {
        return this.itemHandler.map(ItemHandlerHelper::calcRedstoneFromInventory).orElse(0);
    }

    @Override
    public void setFrequency(Frequency frequency) {
        super.setFrequency(frequency);
        this.itemHandler.invalidate();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.getStorage()));
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        this.itemHandler.invalidate();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.getStorage()));
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.itemHandler.invalidate();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.openCount = type;
            return true;
        }
        return false;
    }

    @Override
    public DimChestStorage getStorage() {
        return (DimChestStorage)DimStorageManager.instance(this.field_145850_b.field_72995_K).getStorage(this.getFrequency(), "item");
    }

    public void onPlaced(LivingEntity entity) {
        this.rotation = (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5) & 3;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("rot", (byte)this.rotation);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.rotation = tag.func_74771_c("rot") & 3;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (!this.locked && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public final SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT root = new CompoundNBT();
        root.func_218657_a("Frequency", (INBT)this.getFrequency().serializeNBT());
        root.func_74757_a("locked", this.locked);
        root.func_74774_a("rot", (byte)this.rotation);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, root);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.setFrequency(new Frequency(tag.func_74775_l("Frequency")));
        this.locked = tag.func_74767_n("locked");
        this.rotation = tag.func_74771_c("rot") & 3;
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_74774_a("rot", (byte)this.rotation);
        return tag;
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.rotation = tag.func_74771_c("rot") & 3;
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerDimChest(id, playerInventory, this, false);
    }
}

