/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.items;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.setup.Registration;
import edivad.dimstorage.tile.TileFrequencyOwner;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemDimBase
extends BlockItem {
    public ItemDimBase(Block blockIn) {
        super(blockIn, Registration.globalProperties);
    }

    private Frequency getFreq(ItemStack stack) {
        CompoundNBT stackTag;
        if (stack.func_77942_o() && (stackTag = stack.func_179543_a("DimStorage")) != null && stackTag.func_74764_b("Frequency")) {
            return new Frequency(stackTag.func_74775_l("Frequency"));
        }
        return new Frequency();
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState state) {
        if (super.func_195941_b(context, state)) {
            World world = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            ItemStack stack = context.func_195996_i();
            TileFrequencyOwner tile = (TileFrequencyOwner)world.func_175625_s(pos);
            tile.setFrequency(this.getFreq(stack));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Frequency frequency = this.getFreq(stack);
        if (frequency.hasOwner()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("gui.dimstorage.owner").func_240702_b_(" " + frequency.getOwner()).func_240699_a_(TextFormatting.DARK_RED));
        }
        if (stack.func_77942_o()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("gui.dimstorage.frequency").func_240702_b_(" " + frequency.getChannel()));
        }
    }
}

