/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import edivad.dimstorage.client.screen.element.button.AutoEjectButton;
import edivad.dimstorage.client.screen.pattern.FrequencyScreen;
import edivad.dimstorage.container.ContainerDimTank;
import edivad.dimstorage.tile.TileEntityDimTank;
import edivad.dimstorage.tools.utils.FluidUtils;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class ScreenDimTank
extends FrequencyScreen<ContainerDimTank> {
    private String liquid;
    private String amount;
    private String temperature;
    private String luminosity;
    private String gaseous;
    private String empty;
    private String yes;
    private String no;

    public ScreenDimTank(ContainerDimTank container, PlayerInventory invPlayer, ITextComponent text) {
        super(container, container.owner, invPlayer, text, new ResourceLocation("dimstorage", "textures/gui/dimtank.png"), container.isOpen);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.addComponent((Widget)new AutoEjectButton(this.field_230708_k_ / 2 + 95, this.field_230709_l_ / 2 + 75, (TileEntityDimTank)this.tileOwner));
        this.drawSettings(this.drawSettings);
        this.liquid = new TranslationTextComponent("gui.dimstorage.liquid").getString();
        this.amount = new TranslationTextComponent("gui.dimstorage.amount").getString();
        this.temperature = new TranslationTextComponent("gui.dimstorage.temperature").getString();
        this.luminosity = new TranslationTextComponent("gui.dimstorage.luminosity").getString();
        this.gaseous = new TranslationTextComponent("gui.dimstorage.gas").getString();
        this.empty = new TranslationTextComponent("gui.dimstorage.empty").getString();
        this.yes = new TranslationTextComponent("gui.dimstorage.yes").getString();
        this.no = new TranslationTextComponent("gui.dimstorage.no").getString();
    }

    @Override
    protected void func_230451_b_(MatrixStack mStack, int mouseX, int mouseY) {
        super.func_230451_b_(mStack, mouseX, mouseY);
        FluidStack liquidStack = ((TileEntityDimTank)this.tileOwner).liquidState.clientLiquid;
        if (!liquidStack.isEmpty()) {
            FluidAttributes liquidAttributes = liquidStack.getFluid().getAttributes();
            String liquidName = liquidStack.getDisplayName().getString();
            this.field_230712_o_.func_238421_b_(mStack, this.liquid + " " + liquidName.substring(0, Math.min(14, liquidName.length())), 50.0f, 25.0f, 0x404040);
            this.field_230712_o_.func_238421_b_(mStack, this.amount + " " + liquidStack.getAmount() + " mB", 50.0f, 35.0f, 0x404040);
            this.field_230712_o_.func_238421_b_(mStack, this.temperature + " " + (liquidAttributes.getTemperature() - 273) + "C", 50.0f, 45.0f, 0x404040);
            this.field_230712_o_.func_238421_b_(mStack, this.luminosity + " " + liquidAttributes.getLuminosity(), 50.0f, 55.0f, 0x404040);
            this.field_230712_o_.func_238421_b_(mStack, this.gaseous + " " + (liquidAttributes.isGaseous() ? this.yes : this.no), 50.0f, 65.0f, 0x404040);
        } else {
            this.field_230712_o_.func_238421_b_(mStack, this.liquid + " " + this.empty, 50.0f, 25.0f, 0x404040);
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack mStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(mStack, partialTicks, mouseX, mouseY);
        FluidStack fluid = ((TileEntityDimTank)this.tileOwner).liquidState.clientLiquid;
        int z = ScreenDimTank.getFluidScaled(60, fluid.getAmount());
        TextureAtlasSprite fluidTexture = FluidUtils.getFluidTexture(fluid);
        this.field_230706_i_.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        FluidUtils.color(FluidUtils.getLiquidColorWithBiome(fluid, (TileEntityDimTank)this.tileOwner));
        ScreenDimTank.func_238470_a_((MatrixStack)mStack, (int)(this.field_147003_i + 11), (int)(this.field_147009_r + 21 + z), (int)176, (int)16, (int)(60 - z), (TextureAtlasSprite)fluidTexture);
    }

    private static int getFluidScaled(int pixels, int currentLiquidAmount) {
        int maxLiquidAmount = 16000;
        int x = currentLiquidAmount * pixels / maxLiquidAmount;
        return pixels - x;
    }
}

